/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.URLClassLoaderBase;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbApi;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginHandle;
import com.gtnewhorizons.retrofuturabootstrap.plugin.PluginLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RfbApiImpl
implements RfbApi {
    public static final RfbApiImpl INSTANCE = new RfbApiImpl();

    private RfbApiImpl() {
    }

    @Override
    public ClassLoader platformClassLoader() {
        return URLClassLoaderBase.getPlatformClassLoader();
    }

    @Override
    @NotNull
    public ClassLoader originalSystemClassLoader() {
        return RfbSystemClassLoader.class.getClassLoader();
    }

    @Override
    @NotNull
    public RfbSystemClassLoader compatClassLoader() {
        if (Main.compatLoader == null) {
            throw new IllegalStateException();
        }
        return Main.compatLoader;
    }

    @Override
    @NotNull
    public ExtensibleClassLoader launchClassLoader() {
        if (Main.launchLoader == null) {
            throw new IllegalStateException();
        }
        return Main.launchLoader;
    }

    @Override
    @Nullable
    public RfbPluginHandle findPluginById(@NotNull String id) {
        return PluginLoader.loadedPluginsById.get(id);
    }

    @Override
    @NotNull
    public List<RfbPluginHandle> loadedPlugins() {
        return Collections.unmodifiableList(PluginLoader.loadedPlugins);
    }

    @Override
    public int newestAsmVersion() {
        return 589824;
    }

    @Override
    public int javaMajorVersion() {
        return Main.JAVA_MAJOR_VERSION;
    }

    @Override
    @NotNull
    public String javaVersion() {
        return Main.JAVA_VERSION;
    }

    @Override
    @NotNull
    public Path gameDirectory() {
        return Main.initialGameDir == null ? Paths.get(".", new String[0]) : Main.initialGameDir.toPath();
    }

    @Override
    @NotNull
    public Path assetsDirectory() {
        return Main.initialAssetsDir == null ? Paths.get(".", new String[0]) : Main.initialAssetsDir.toPath();
    }

    @Override
    public long currentPid() {
        return URLClassLoaderBase.getCurrentPid();
    }
}

