/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.rfbplugins.compat.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassHeaderMetadata;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.gtnewhorizons.retrofuturabootstrap.asm.UuidStringConstructor;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class UuidTransformer
implements RfbClassTransformer {
    public static final Attributes.Name MANIFEST_SAFE_ATTRIBUTE = new Attributes.Name("Has-Safe-UUID");
    final String UUID_NAME = Type.getInternalName(UUID.class);
    final byte[] UUID_NAME_BYTES = this.UUID_NAME.getBytes(StandardCharsets.UTF_8);
    final String REDIRECTION_NAME = Type.getInternalName(UuidStringConstructor.class);

    @Override
    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "uuid";
    }

    @Override
    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return false;
        }
        if (manifest != null && "true".equals(manifest.getMainAttributes().getValue(MANIFEST_SAFE_ATTRIBUTE))) {
            return false;
        }
        if (classNode.getOriginalMetadata() != null && classNode.getOriginalMetadata().majorVersion >= 53) {
            return false;
        }
        return ClassHeaderMetadata.hasSubstring(classNode.getOriginalBytes(), this.UUID_NAME_BYTES);
    }

    @Override
    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode node = classNode.getNode();
        if (node == null || node.methods == null) {
            return;
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode rawInsn : method.instructions) {
                if (rawInsn.getType() != 5) continue;
                MethodInsnNode insn = (MethodInsnNode)rawInsn;
                if (!insn.owner.equals(this.UUID_NAME) || !insn.name.equals("fromString") || !insn.desc.equals("(Ljava/lang/String;)Ljava/util/UUID;")) continue;
                insn.owner = this.REDIRECTION_NAME;
            }
        }
    }
}

