/*
 * Decompiled with CFR 0.152.
 */
package advsolar.common;

import advsolar.common.ASPServerProxy;
import advsolar.common.blocks.BlockAdvSolarPanel;
import advsolar.common.blocks.BlockMolecularTransformer;
import advsolar.common.items.ItemAdvSolarPanel;
import advsolar.common.items.ItemAdvanced;
import advsolar.common.items.ItemAdvancedSolarHelmet;
import advsolar.common.items.ItemMolecularTransformer;
import advsolar.common.tiles.TileEntityAdvancedSolarPanel;
import advsolar.common.tiles.TileEntityHybridSolarPanel;
import advsolar.common.tiles.TileEntityMolecularTransformer;
import advsolar.common.tiles.TileEntityQGenerator;
import advsolar.common.tiles.TileEntityQuantumSolarPanel;
import advsolar.common.tiles.TileEntityUltimateSolarPanel;
import advsolar.network.ASPPacketHandler;
import advsolar.utils.MTRecipeConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="AdvancedSolarPanel", name="Advanced Solar Panels", dependencies="required-after:IC2; after:gregtech_addon; after:AppliedEnergistics;", version="1.7.10-3.5.1")
public class AdvancedSolarPanel {
    @SidedProxy(clientSide="advsolar.client.ASPClientProxy", serverSide="advsolar.common.ASPServerProxy")
    public static ASPServerProxy proxy;
    public static Block blockAdvSolarPanel;
    public static Block blockMolecularTransformer;
    public static Item itemAdvanced;
    public static Item advancedSolarHelmet;
    public static Item hybridSolarHelmet;
    public static Item ultimateSolarHelmet;
    public static ItemStack itemSunnarium;
    public static ItemStack itemSunnariumPart;
    public static ItemStack itemSunnariumAlloy;
    public static ItemStack ingotIridium;
    public static ItemStack itemIrradiantUranium;
    public static ItemStack itemEnrichedSunnarium;
    public static ItemStack itemEnrichedSunnariumAlloy;
    public static ItemStack itemIrradiantGlassPane;
    public static ItemStack itemIridiumIronPlate;
    public static ItemStack itemReinforcedIridiumIronPlate;
    public static ItemStack itemIrradiantReinforcedPlate;
    public static ItemStack itemQuantumCore;
    public static ItemStack itemUranIngot;
    public static ItemStack itemUHSP;
    public static ItemStack itemMTCore;
    public static ItemStack itemMolecularTransformer;
    public static Configuration config;
    public static String configFileName;
    public static int advGenDay;
    public static int advGenNight;
    public static int advStorage;
    public static int advOutput;
    public static int hGenDay;
    public static int hGenNight;
    public static int hStorage;
    public static int hOutput;
    public static int uhGenDay;
    public static int uhGenNight;
    public static int uhStorage;
    public static int uhOutput;
    public static int qpGenDay;
    public static int qpGenNight;
    public static int qpStorage;
    public static int qpOutput;
    public static int qgbaseProduction;
    public static int qgbaseMaxPacketSize;
    public static int blockMolecularTransformerRenderID;
    public static CreativeTabs ic2Tab;
    private static boolean disableAdvancedSolarHelmetRecipe;
    private static boolean disableHybridSolarHelmetRecipe;
    private static boolean disableUltimateSolarHelmetRecipe;
    private static boolean disableAdvancedSolarPanelRecipe;
    private static boolean disableHybridSolarPanelRecipe;
    private static boolean disableUltimateSolarPanelRecipe;
    private static boolean disableQuantumSolarPanelRecipe;
    private static boolean disableMolecularTransformerRecipe;
    private static boolean disableDoubleSlabRecipe;
    private static boolean enableSimpleAdvancedSolarPanelRecipes;
    private static boolean enableHardRecipes;
    public static final String CATEGORY_RECIPES = "recipes settings";
    public static final String CATEGORY_QGENERATOR = "quantum generator";
    public static final Side side;
    @Mod.Instance(value="AdvancedSolarPanel")
    public static AdvancedSolarPanel instance;

    public static ItemStack setItemsSize(ItemStack itemStack, int newSize) {
        ItemStack newStack = itemStack.func_77946_l();
        newStack.field_77994_a = newSize;
        return newStack;
    }

    public static void getIC2Tab() {
        for (int i = 0; i < CreativeTabs.field_78032_a.length; ++i) {
            if (CreativeTabs.field_78032_a[i].func_78013_b() != "IC2") continue;
            ic2Tab = CreativeTabs.field_78032_a[i];
        }
    }

    public static boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static void addLog(String logLine) {
        System.out.println("[AdvancedSolarPanel] " + logLine);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            configFileName = event.getSuggestedConfigurationFile().getAbsolutePath();
            advGenDay = config.get("general", "AdvancedSPGenDay", 8).getInt(8);
            advGenNight = config.get("general", "AdvancedSPGenNight", 1).getInt(1);
            advStorage = config.get("general", "AdvancedSPStorage", 32000).getInt(32000);
            advOutput = config.get("general", "AdvancedSPOutput", 32).getInt(32);
            hGenDay = config.get("general", "HybrydSPGenDay", 64).getInt(64);
            hGenNight = config.get("general", "HybrydSPGenNight", 8).getInt(8);
            hStorage = config.get("general", "HybrydSPStorage", 100000).getInt(100000);
            hOutput = config.get("general", "HybrydSPOutput", 128).getInt(128);
            uhGenDay = config.get("general", "UltimateHSPGenDay", 512).getInt(512);
            uhGenNight = config.get("general", "UltimateHSPGenNight", 64).getInt(64);
            uhStorage = config.get("general", "UltimateHSPStorage", 1000000).getInt(1000000);
            uhOutput = config.get("general", "UltimateHSPOutput", 512).getInt(512);
            qpGenDay = config.get("general", "QuantumSPGenDay", 4096).getInt(4096);
            qpGenNight = config.get("general", "QuantumSPGenNight", 2048).getInt(2048);
            qpStorage = config.get("general", "QuantumSPStorage", 10000000).getInt(10000000);
            qpOutput = config.get("general", "QuantumSPOutput", 8192).getInt(8192);
            qgbaseProduction = config.get(CATEGORY_QGENERATOR, "quantumGeneratorDefaultProduction", 512).getInt(512);
            qgbaseMaxPacketSize = config.get(CATEGORY_QGENERATOR, "quantumGeneratorDefaultPacketSize", 512).getInt(512);
            disableAdvancedSolarHelmetRecipe = config.get(CATEGORY_RECIPES, "Disable Advanced Solar Helmet recipe", false).getBoolean(false);
            disableHybridSolarHelmetRecipe = config.get(CATEGORY_RECIPES, "Disable Hybrid Solar Helmet recipe", false).getBoolean(false);
            disableUltimateSolarHelmetRecipe = config.get(CATEGORY_RECIPES, "Disable Ultimate Solar Helmet recipe", false).getBoolean(false);
            disableAdvancedSolarPanelRecipe = config.get(CATEGORY_RECIPES, "Disable AdvancedSolarPanel recipe", false).getBoolean(false);
            disableHybridSolarPanelRecipe = config.get(CATEGORY_RECIPES, "Disable HybridSolarPanel recipe", false).getBoolean(false);
            disableUltimateSolarPanelRecipe = config.get(CATEGORY_RECIPES, "Disable UltimateSolarPanel recipe", false).getBoolean(false);
            disableQuantumSolarPanelRecipe = config.get(CATEGORY_RECIPES, "Disable QuantumSolarPanel recipe", false).getBoolean(false);
            disableMolecularTransformerRecipe = config.get(CATEGORY_RECIPES, "Disable MolecularTransformer recipe", false).getBoolean(false);
            disableDoubleSlabRecipe = config.get(CATEGORY_RECIPES, "Disable DoubleSlab recipe", false).getBoolean(false);
            enableSimpleAdvancedSolarPanelRecipes = config.get(CATEGORY_RECIPES, "Enable simple Advanced Solar Panel recipe", false).getBoolean(false);
            enableHardRecipes = config.get(CATEGORY_RECIPES, "Enable hard recipes", true).getBoolean(true);
        }
        catch (Exception e) {
            System.out.println("[AdvancedSolarPanels] error occurred parsing config file");
            throw new RuntimeException(e);
        }
        finally {
            config.save();
        }
        if (side == Side.CLIENT) {
            AdvancedSolarPanel.getIC2Tab();
        }
        blockMolecularTransformer = new BlockMolecularTransformer();
        GameRegistry.registerBlock((Block)blockMolecularTransformer, ItemMolecularTransformer.class, (String)"BlockMolecularTransformer");
        GameRegistry.registerTileEntity(TileEntityMolecularTransformer.class, (String)"Molecular Transformer");
        blockAdvSolarPanel = new BlockAdvSolarPanel();
        GameRegistry.registerBlock((Block)blockAdvSolarPanel, ItemAdvSolarPanel.class, (String)"BlockAdvSolarPanel");
        GameRegistry.registerTileEntity(TileEntityAdvancedSolarPanel.class, (String)"Advanced Solar Panel");
        GameRegistry.registerTileEntity(TileEntityHybridSolarPanel.class, (String)"Hybrid Solar Panel");
        GameRegistry.registerTileEntity(TileEntityUltimateSolarPanel.class, (String)"Ultimate Hybrid Solar Panel");
        GameRegistry.registerTileEntity(TileEntityQuantumSolarPanel.class, (String)"Quantum Solar Panel");
        GameRegistry.registerTileEntity(TileEntityQGenerator.class, (String)"Quantum Generator");
        advancedSolarHelmet = new ItemAdvancedSolarHelmet(ItemArmor.ArmorMaterial.DIAMOND, proxy.addArmor("advancedSolarHelmet"), 0, 1).func_77655_b("advancedSolarHelmet");
        GameRegistry.registerItem((Item)advancedSolarHelmet, (String)"advanced_solar_helmet");
        hybridSolarHelmet = new ItemAdvancedSolarHelmet(ItemArmor.ArmorMaterial.DIAMOND, proxy.addArmor("hybridSolarHelmet"), 0, 2).func_77655_b("hybridSolarHelmet");
        GameRegistry.registerItem((Item)hybridSolarHelmet, (String)"hybrid_solar_helmet");
        ultimateSolarHelmet = new ItemAdvancedSolarHelmet(ItemArmor.ArmorMaterial.DIAMOND, proxy.addArmor("ultimateSolarHelmet"), 0, 3).func_77655_b("ultimateSolarHelmet");
        GameRegistry.registerItem((Item)ultimateSolarHelmet, (String)"ultimate_solar_helmet");
        itemAdvanced = new ItemAdvanced();
        GameRegistry.registerItem((Item)itemAdvanced, (String)"asp_crafting_items");
        itemSunnarium = new ItemStack(itemAdvanced.func_77655_b("itemSunnarium"), 1, 0);
        itemSunnariumAlloy = new ItemStack(itemAdvanced.func_77655_b("itemSunnariumAlloy"), 1, 1);
        itemIrradiantUranium = new ItemStack(itemAdvanced.func_77655_b("itemIrradiantUranium"), 1, 2);
        itemEnrichedSunnarium = new ItemStack(itemAdvanced.func_77655_b("itemEnrichedSunnarium"), 1, 3);
        itemEnrichedSunnariumAlloy = new ItemStack(itemAdvanced.func_77655_b("itemEnrichedSunnariumAlloy"), 1, 4);
        itemIrradiantGlassPane = new ItemStack(itemAdvanced.func_77655_b("itemIrradiantGlassPlane"), 1, 5);
        itemIridiumIronPlate = new ItemStack(itemAdvanced.func_77655_b("itemIridiumIronPlate"), 1, 6);
        itemReinforcedIridiumIronPlate = new ItemStack(itemAdvanced.func_77655_b("itemReinforcedIridiumIronPlate"), 1, 7);
        itemIrradiantReinforcedPlate = new ItemStack(itemAdvanced.func_77655_b("itemIrradiantReinforcedPlate"), 1, 8);
        itemSunnariumPart = new ItemStack(itemAdvanced.func_77655_b("itemSunnariumPart"), 1, 9);
        ingotIridium = new ItemStack(itemAdvanced.func_77655_b("ingotIridium"), 1, 10);
        itemUranIngot = new ItemStack(itemAdvanced.func_77655_b("itemUranIngot"), 1, 11);
        itemMTCore = new ItemStack(itemAdvanced.func_77655_b("itemMTCore"), 1, 12);
        itemQuantumCore = new ItemStack(itemAdvanced.func_77655_b("itemQuantumCore"), 1, 13);
        itemMolecularTransformer = new ItemStack(blockMolecularTransformer, 1, 0);
        itemUHSP = new ItemStack(blockAdvSolarPanel, 1, 2);
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(IC2Items.getItem((String)"iridiumOre"), 1), null, new ItemStack[]{ingotIridium});
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(IC2Items.getItem((String)"UranFuel"), 1), null, new ItemStack[]{itemUranIngot});
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(IC2Items.getItem((String)"uraniumOre"), 1), null, new ItemStack[]{itemUranIngot});
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(IC2Items.getItem((String)"crushedUraniumOre"), 1), null, new ItemStack[]{itemUranIngot});
        OreDictionary.registerOre((String)"ingotUranium", (ItemStack)itemUranIngot);
        OreDictionary.registerOre((String)"ingotIridium", (ItemStack)ingotIridium);
        OreDictionary.registerOre((String)"craftingSolarPanelHV", (ItemStack)itemUHSP);
        OreDictionary.registerOre((String)"craftingSunnariumPart", (ItemStack)itemSunnariumPart);
        OreDictionary.registerOre((String)"craftingSunnarium", (ItemStack)itemSunnarium);
        OreDictionary.registerOre((String)"craftingMTCore", (ItemStack)itemMTCore);
        OreDictionary.registerOre((String)"craftingMolecularTransformer", (ItemStack)itemMolecularTransformer);
        proxy.registerRenderers();
        proxy.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MTRecipeConfig.doDebug();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ASPPacketHandler.load();
    }

    @Mod.EventHandler
    public void afterModsLoaded(FMLPostInitializationEvent event) {
        proxy.initRecipes();
        if (!disableAdvancedSolarHelmetRecipe) {
            Recipes.advRecipes.addRecipe(new ItemStack(advancedSolarHelmet, 1), new Object[]{" A ", "RBR", "FDF", Character.valueOf('A'), new ItemStack(blockAdvSolarPanel, 1, 0), Character.valueOf('B'), IC2Items.getItem((String)"nanoHelmet"), Character.valueOf('R'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"lvTransformer"), Character.valueOf('F'), IC2Items.getItem((String)"insulatedGoldCableItem")});
        }
        if (!disableHybridSolarHelmetRecipe) {
            Recipes.advRecipes.addRecipe(new ItemStack(hybridSolarHelmet, 1), new Object[]{" A ", "RBR", "FDF", Character.valueOf('A'), new ItemStack(blockAdvSolarPanel, 1, 1), Character.valueOf('B'), IC2Items.getItem((String)"quantumHelmet"), Character.valueOf('R'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"hvTransformer"), Character.valueOf('F'), IC2Items.getItem((String)"glassFiberCableItem")});
        }
        if (!disableUltimateSolarHelmetRecipe) {
            Recipes.advRecipes.addRecipe(new ItemStack(ultimateSolarHelmet, 1), new Object[]{" A ", "RBR", "FDF", Character.valueOf('A'), new ItemStack(blockAdvSolarPanel, 1, 2), Character.valueOf('B'), IC2Items.getItem((String)"quantumHelmet"), Character.valueOf('R'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"hvTransformer"), Character.valueOf('F'), IC2Items.getItem((String)"glassFiberCableItem")});
            Recipes.advRecipes.addRecipe(new ItemStack(ultimateSolarHelmet, 1), new Object[]{"A", "B", Character.valueOf('A'), new ItemStack(blockAdvSolarPanel, 1, 2), Character.valueOf('B'), new ItemStack(hybridSolarHelmet, 1)});
        }
        if (!enableHardRecipes) {
            if (!disableAdvancedSolarPanelRecipe) {
                Recipes.advRecipes.addRecipe(itemIridiumIronPlate, new Object[]{"AAA", "ABA", "AAA", Character.valueOf('A'), "plateIron", Character.valueOf('B'), "ingotIridium"});
                GameRegistry.addRecipe((ItemStack)itemReinforcedIridiumIronPlate, (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('B'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('C'), itemIridiumIronPlate});
                GameRegistry.addRecipe((ItemStack)itemIrradiantReinforcedPlate, (Object[])new Object[]{"ABA", "DCD", "AFA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), itemSunnariumPart, Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('C'), itemReinforcedIridiumIronPlate, Character.valueOf('F'), Items.field_151045_i});
                if (enableSimpleAdvancedSolarPanelRecipes) {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 0), (Object[])new Object[]{"RRR", "DSD", "ABA", Character.valueOf('R'), IC2Items.getItem((String)"reinforcedGlass"), Character.valueOf('D'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('S'), IC2Items.getItem((String)"solarPanel"), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), IC2Items.getItem((String)"advancedMachine")});
                } else {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 0), (Object[])new Object[]{"RRR", "DSD", "ABA", Character.valueOf('R'), IC2Items.getItem((String)"reinforcedGlass"), Character.valueOf('D'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('S'), IC2Items.getItem((String)"solarPanel"), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), itemIrradiantReinforcedPlate});
                }
            }
            if (!disableUltimateSolarPanelRecipe && !disableAdvancedSolarPanelRecipe) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 2), (Object[])new Object[]{" A ", "XMX", "RXR", Character.valueOf('A'), Blocks.field_150368_y, Character.valueOf('X'), IC2Items.getItem((String)"coalChunk"), Character.valueOf('M'), new ItemStack(blockAdvSolarPanel, 1, 0), Character.valueOf('R'), itemSunnariumAlloy});
            }
            if (!disableHybridSolarPanelRecipe && !disableAdvancedSolarPanelRecipe) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 1), (Object[])new Object[]{"XMX", "DSD", "ABA", Character.valueOf('X'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('M'), Blocks.field_150368_y, Character.valueOf('D'), IC2Items.getItem((String)"iridiumPlate"), Character.valueOf('S'), new ItemStack(blockAdvSolarPanel, 1, 0), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), itemSunnarium});
                if (!disableUltimateSolarPanelRecipe) {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 2), (Object[])new Object[]{"MMM", "MXM", "MMM", Character.valueOf('M'), new ItemStack(blockAdvSolarPanel, 1, 1), Character.valueOf('X'), IC2Items.getItem((String)"advancedCircuit")});
                }
            }
        } else {
            if (!disableAdvancedSolarPanelRecipe) {
                ArrayList iridiumList = OreDictionary.getOres((String)"ingotIridium");
                for (ItemStack itemStack : iridiumList) {
                    GameRegistry.addRecipe((ItemStack)itemIridiumIronPlate, (Object[])new Object[]{"AAA", "ABA", "AAA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), itemStack});
                }
                GameRegistry.addRecipe((ItemStack)itemReinforcedIridiumIronPlate, (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('B'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('C'), itemIridiumIronPlate});
                GameRegistry.addRecipe((ItemStack)itemIrradiantReinforcedPlate, (Object[])new Object[]{"ABA", "DCD", "AFA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), itemSunnariumPart, Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('C'), itemReinforcedIridiumIronPlate, Character.valueOf('F'), Items.field_151045_i});
                if (enableSimpleAdvancedSolarPanelRecipes) {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 0), (Object[])new Object[]{"RRR", "DSD", "ABA", Character.valueOf('R'), itemIrradiantGlassPane, Character.valueOf('D'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('S'), IC2Items.getItem((String)"solarPanel"), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), IC2Items.getItem((String)"advancedMachine")});
                } else {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 0), (Object[])new Object[]{"RRR", "DSD", "ABA", Character.valueOf('R'), itemIrradiantGlassPane, Character.valueOf('D'), IC2Items.getItem((String)"advancedAlloy"), Character.valueOf('S'), IC2Items.getItem((String)"solarPanel"), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), itemIrradiantReinforcedPlate});
                }
            }
            if (!disableUltimateSolarPanelRecipe && !disableAdvancedSolarPanelRecipe) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 2), (Object[])new Object[]{" A ", "XMX", "RXR", Character.valueOf('A'), Blocks.field_150368_y, Character.valueOf('X'), IC2Items.getItem((String)"coalChunk"), Character.valueOf('M'), new ItemStack(blockAdvSolarPanel, 1, 0), Character.valueOf('R'), itemEnrichedSunnariumAlloy});
            }
            if (!disableHybridSolarPanelRecipe && !disableAdvancedSolarPanelRecipe) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 1), (Object[])new Object[]{"XMX", "DSD", "ABA", Character.valueOf('X'), IC2Items.getItem((String)"carbonPlate"), Character.valueOf('M'), Blocks.field_150368_y, Character.valueOf('D'), IC2Items.getItem((String)"iridiumPlate"), Character.valueOf('S'), new ItemStack(blockAdvSolarPanel, 1, 0), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), itemEnrichedSunnarium});
            }
        }
        if (!disableUltimateSolarPanelRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 2), (Object[])new Object[]{"MMM", "MXM", "MMM", Character.valueOf('M'), new ItemStack(blockAdvSolarPanel, 1, 1), Character.valueOf('X'), IC2Items.getItem((String)"advancedCircuit")});
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 8, 1), (Object[])new Object[]{"X", Character.valueOf('X'), new ItemStack(blockAdvSolarPanel, 1, 2)});
        }
        if (!disableMolecularTransformerRecipe) {
            GameRegistry.addRecipe((ItemStack)itemMTCore, (Object[])new Object[]{"MXM", "M M", "MXM", Character.valueOf('M'), itemIrradiantGlassPane, Character.valueOf('X'), IC2Items.getItem((String)"reactorReflectorThick")});
            GameRegistry.addRecipe((ItemStack)itemMolecularTransformer, (Object[])new Object[]{"MXM", "ABA", "MXM", Character.valueOf('M'), IC2Items.getItem((String)"advancedMachine"), Character.valueOf('X'), IC2Items.getItem((String)"evTransformer"), Character.valueOf('A'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('B'), itemMTCore});
        }
        if (!disableQuantumSolarPanelRecipe) {
            GameRegistry.addRecipe((ItemStack)itemQuantumCore, (Object[])new Object[]{"XRX", "RSR", "XRX", Character.valueOf('X'), itemEnrichedSunnariumAlloy, Character.valueOf('R'), Items.field_151156_bN, Character.valueOf('S'), Items.field_151061_bv});
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvSolarPanel, 1, 3), (Object[])new Object[]{"XXX", "XRX", "XXX", Character.valueOf('X'), new ItemStack(blockAdvSolarPanel, 1, 2), Character.valueOf('R'), itemQuantumCore});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemIrradiantUranium, new Object[]{" R ", "RSR", " R ", Character.valueOf('R'), Items.field_151114_aO, Character.valueOf('S'), "ingotUranium"}));
        GameRegistry.addRecipe((ItemStack)AdvancedSolarPanel.setItemsSize(itemIrradiantGlassPane, 6), (Object[])new Object[]{"RRR", "ASA", "RRR", Character.valueOf('R'), IC2Items.getItem((String)"reinforcedGlass"), Character.valueOf('A'), itemIrradiantUranium, Character.valueOf('S'), Items.field_151114_aO});
        GameRegistry.addRecipe((ItemStack)itemEnrichedSunnarium, (Object[])new Object[]{"RRR", "RSR", "RRR", Character.valueOf('R'), itemIrradiantUranium, Character.valueOf('S'), itemSunnarium});
        GameRegistry.addRecipe((ItemStack)itemEnrichedSunnariumAlloy, (Object[])new Object[]{" R ", "RSR", " R ", Character.valueOf('R'), itemEnrichedSunnarium, Character.valueOf('S'), itemSunnariumAlloy});
        GameRegistry.addRecipe((ItemStack)itemSunnariumAlloy, (Object[])new Object[]{"MMM", "MXM", "MMM", Character.valueOf('M'), IC2Items.getItem((String)"iridiumPlate"), Character.valueOf('X'), itemSunnarium});
        GameRegistry.addRecipe((ItemStack)itemSunnarium, (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), itemSunnariumPart});
        if (!disableDoubleSlabRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)Blocks.field_150334_T, 1, 0), (Object[])new Object[]{"A", "A", Character.valueOf('A'), new ItemStack((Block)Blocks.field_150333_U, 1, 0)});
        }
    }

    static {
        side = FMLCommonHandler.instance().getEffectiveSide();
        instance = new AdvancedSolarPanel();
    }
}

