/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.inventory.ContainerArtificalGravity;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tile.TileEntityGravitation;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiArtificialGravity
extends GuiContainerGC
implements GuiElementTextBox.ITextBoxCallback,
GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("amunra", "textures/gui/gravity.png");
    protected final List<GuiElementTextBox> inputFieldList = new ArrayList<GuiElementTextBox>();
    private GuiElementTextBox leftValueField;
    private GuiElementTextBox rightValueField;
    private GuiElementTextBox frontValueField;
    private GuiElementTextBox backValueField;
    private GuiElementTextBox topValueField;
    private GuiElementTextBox bottomValueField;
    private GuiElementTextBox strengthField;
    private GuiElementCheckbox checkboxInvert;
    private GuiElementCheckbox checkboxVisualGuide;
    private GuiButton disableButton;
    private AxisAlignedBB tempBox;
    private double tempGravityStrength;
    private boolean tempIsInverted;
    public static final int FIELD_TOP = 0;
    public static final int FIELD_LEFT = 1;
    public static final int FIELD_FRONT = 2;
    public static final int FIELD_BACK = 3;
    public static final int FIELD_RIGHT = 4;
    public static final int FIELD_BOTTOM = 5;
    public static final int FIELD_STRENGTH = 10;
    public static final int BTN_ENABLE = 6;
    public static final int CHECKBOX_VISUAL = 8;
    public static final int CHECKBOX_INVERT = 11;
    private final GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 87, 52, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
    private final TileEntityGravitation tile;

    public GuiArtificialGravity(InventoryPlayer player, TileEntityGravitation tile) {
        super((Container)new ContainerArtificalGravity(player, tile));
        this.field_146999_f = 176;
        this.field_147000_g = 231;
        this.tile = tile;
        this.tempGravityStrength = tile.getGravityForce() * 100.0;
        this.tempIsInverted = this.tempGravityStrength > 0.0;
        this.tempGravityStrength = Math.abs(this.tempGravityStrength);
    }

    private AxisAlignedBB cloneAABB(AxisAlignedBB box) {
        return AxisAlignedBB.func_72330_a((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c, (double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
    }

    protected void sendDataToServer() {
        BlockVec3 pos = new BlockVec3((TileEntity)this.tile);
        BlockVec3 min = new BlockVec3((int)this.tempBox.field_72340_a, (int)this.tempBox.field_72338_b, (int)this.tempBox.field_72339_c);
        BlockVec3 max = new BlockVec3((int)this.tempBox.field_72336_d, (int)this.tempBox.field_72337_e, (int)this.tempBox.field_72334_f);
        double actualStrength = this.tempGravityStrength / 100.0;
        if (!this.tempIsInverted) {
            actualStrength *= -1.0;
        }
        AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_ARTIFICIAL_GRAVITY_SETTINGS, pos, min, max, actualStrength));
        this.tile.setGravityBox(this.cloneAABB(this.tempBox));
        this.tile.setGravityForce(actualStrength);
    }

    protected void resetDataFromTile() {
        this.tempBox = this.cloneAABB(this.tile.getGravityBox());
        this.topValueField.text = Integer.toString((int)this.tempBox.field_72337_e);
        this.backValueField.text = Integer.toString((int)this.tempBox.field_72334_f);
        this.rightValueField.text = Integer.toString((int)this.tempBox.field_72336_d);
        this.bottomValueField.text = Integer.toString((int)this.tempBox.field_72338_b * -1);
        this.frontValueField.text = Integer.toString((int)this.tempBox.field_72339_c * -1);
        this.leftValueField.text = Integer.toString((int)this.tempBox.field_72340_a * -1);
        this.tempGravityStrength = this.tile.getGravityForce() * 100.0;
        this.tempIsInverted = this.tempGravityStrength > 0.0;
        this.tempGravityStrength = Math.abs(this.tempGravityStrength);
    }

    protected void func_146284_a(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 6: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 152, (this.field_146295_m - this.field_147000_g) / 2 + 134, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 98;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 118 + 22;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        int offsetX1 = 10;
        int offsetX2 = 50;
        this.topValueField = new GuiElementTextBox(0, (GuiElementTextBox.ITextBoxCallback)this, 10 + guiX + 32, guiY + 28 - 4, 28, 18, "0", true, 2, true);
        this.leftValueField = new GuiElementTextBox(1, (GuiElementTextBox.ITextBoxCallback)this, 10 + guiX + 2, guiY + 44, 28, 18, "0", true, 2, true);
        this.frontValueField = new GuiElementTextBox(2, (GuiElementTextBox.ITextBoxCallback)this, 50 + guiX + 62 - 40, guiY + 28 + 16, 28, 18, "0", true, 2, true);
        this.backValueField = new GuiElementTextBox(3, (GuiElementTextBox.ITextBoxCallback)this, 10 + guiX + 2, guiY + 64, 28, 18, "0", true, 2, true);
        this.rightValueField = new GuiElementTextBox(4, (GuiElementTextBox.ITextBoxCallback)this, 50 + guiX + 22, guiY + 48 + 16, 28, 18, "0", true, 2, true);
        this.bottomValueField = new GuiElementTextBox(5, (GuiElementTextBox.ITextBoxCallback)this, 10 + guiX + 32, guiY + 68 + 16, 28, 18, "0", true, 2, true);
        this.addInputField(this.leftValueField);
        this.addInputField(this.backValueField);
        this.addInputField(this.bottomValueField);
        this.addInputField(this.rightValueField);
        this.addInputField(this.frontValueField);
        this.addInputField(this.topValueField);
        int yOffsetBtns = -7;
        this.disableButton = new GuiButton(6, guiX + 110, guiY + 90 + -7, 50, 20, GCCoreUtil.translate((String)"gui.button.disable.name"));
        this.checkboxVisualGuide = new GuiElementCheckbox(8, (GuiElementCheckbox.ICheckBoxCallback)this, guiX + 80, guiY + 24, GCCoreUtil.translate((String)"gui.checkbox.show_visual_guide"));
        this.field_146292_n.add(this.disableButton);
        this.field_146292_n.add(this.checkboxVisualGuide);
        this.strengthField = new GuiElementTextBox(10, (GuiElementTextBox.ITextBoxCallback)this, guiX + 60, guiY + 110, 38, 18, "0", true, 2, true);
        this.addInputField(this.strengthField);
        this.checkboxInvert = new GuiElementCheckbox(11, (GuiElementCheckbox.ICheckBoxCallback)this, guiX + 100, guiY + 112, GCCoreUtil.translate((String)"gui.checkbox.invert_force"));
        this.field_146292_n.add(this.checkboxInvert);
    }

    protected void addInputField(GuiElementTextBox box) {
        this.field_146292_n.add(box);
        this.inputFieldList.add(box);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tile.func_145825_b(), 8, 10, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 90 + 2, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xOffset, yOffset + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile != null) {
            this.disableButton.field_146126_j = this.tile.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.enable.name") : GCCoreUtil.translate((String)"gui.button.disable.name");
            int scale = this.tile.getScaledElecticalLevel(54);
            this.func_73729_b(xOffset + 99, yOffset + 119 + 22, 176, 0, Math.min(scale, 54), 7);
            ArrayList<String> electricityDesc = new ArrayList<String>();
            electricityDesc.add(GCCoreUtil.translate((String)"gui.energyStorage.desc.0"));
            EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
            electricityDesc.add(EnumChatFormatting.AQUA + GCCoreUtil.translate((String)"gui.message.energy_usage") + ": " + EnergyDisplayHelper.getEnergyDisplayS((float)this.tile.storage.getMaxExtract()) + "/t");
            this.electricInfoRegion.tooltipStrings = electricityDesc;
            this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus(), xOffset + 8, yOffset + 130, 0x404040);
            this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.message.force.strength") + ": ", xOffset + 8, yOffset + 116, 0x404040);
        }
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return true;
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        double newValue;
        if (newText == null) {
            return;
        }
        try {
            newValue = Double.parseDouble(newText);
        }
        catch (NumberFormatException wat) {
            return;
        }
        if (newValue < 0.0) {
            return;
        }
        switch (textBox.field_146127_k) {
            case 0: {
                this.tempBox.field_72337_e = (int)newValue;
                break;
            }
            case 3: {
                this.tempBox.field_72334_f = (int)newValue;
                break;
            }
            case 4: {
                this.tempBox.field_72336_d = (int)newValue;
                break;
            }
            case 5: {
                this.tempBox.field_72338_b = (int)newValue * -1;
                break;
            }
            case 2: {
                this.tempBox.field_72339_c = (int)newValue * -1;
                break;
            }
            case 1: {
                this.tempBox.field_72340_a = (int)newValue * -1;
                break;
            }
            case 10: {
                this.tempGravityStrength = Math.abs(newValue);
                break;
            }
            default: {
                return;
            }
        }
        this.sendDataToServer();
    }

    public String getInitialText(GuiElementTextBox textBox) {
        this.tempBox = this.tile.getGravityBox();
        switch (textBox.field_146127_k) {
            case 0: {
                return Integer.toString((int)this.tempBox.field_72337_e);
            }
            case 3: {
                return Integer.toString((int)this.tempBox.field_72334_f);
            }
            case 4: {
                return Integer.toString((int)this.tempBox.field_72336_d);
            }
            case 5: {
                return Integer.toString((int)this.tempBox.field_72338_b * -1);
            }
            case 2: {
                return Integer.toString((int)this.tempBox.field_72339_c * -1);
            }
            case 1: {
                return Integer.toString((int)this.tempBox.field_72340_a * -1);
            }
            case 10: {
                return Integer.toString((int)Math.abs(this.tempGravityStrength));
            }
        }
        return Integer.toString(textBox.field_146127_k);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode != 1) {
            for (GuiElementTextBox box : this.inputFieldList) {
                if (!box.keyTyped(typedChar, keyCode)) continue;
                return;
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return -15401196;
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        switch (checkbox.field_146127_k) {
            case 8: {
                this.tile.isBoxShown = newSelected;
                this.sendDataToServer();
                break;
            }
            case 11: {
                this.tempIsInverted = newSelected;
                this.sendDataToServer();
            }
        }
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        switch (checkbox.field_146127_k) {
            case 8: {
                return this.tile.isBoxShown;
            }
            case 11: {
                return this.tempIsInverted;
            }
        }
        return false;
    }

    public void onIntruderInteraction() {
    }

    protected String getStatus() {
        return this.tile.getGUIstatus();
    }
}

