/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.inventory.ContainerHydroponics;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tile.TileEntityHydroponics;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiHydroponics
extends GuiContainerGC {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("amunra", "textures/gui/hydroponics.png");
    private final GuiElementInfoRegion oxygenInfoRegion;
    private final GuiElementInfoRegion electricInfoRegion;
    private final TileEntityHydroponics tile;
    private GuiButton button;

    public GuiHydroponics(InventoryPlayer player, TileEntityHydroponics tile) {
        super((Container)new ContainerHydroponics(player, tile));
        this.oxygenInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 24, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 37, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.field_147000_g = 201;
        this.field_146999_f = 176;
        this.tile = tile;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            float growthStatus = this.tile.getPlantGrowthStatus();
            if (growthStatus < 0.0f) {
                AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_HYDROPONICS_OPERATION, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, TileEntityHydroponics.OperationType.PLANT_SEED.ordinal()));
            } else if (growthStatus < 1.0f) {
                AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_HYDROPONICS_OPERATION, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, TileEntityHydroponics.OperationType.FERTILIZE.ordinal()));
            } else if (growthStatus == 1.0f) {
                AmunRa.packetPipeline.sendToServer(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.S_HYDROPONICS_OPERATION, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, TileEntityHydroponics.OperationType.HARVEST.ordinal()));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 31, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.oxygenInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.oxygenInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.oxygenInfoRegion.parentWidth = this.field_146294_l;
        this.oxygenInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.oxygenInfoRegion);
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 37;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        float growStatus = this.tile.getPlantGrowthStatus();
        this.button = new GuiButton(0, (this.field_146294_l - this.field_146999_f) / 2 + 82, (this.field_146295_m - this.field_147000_g) / 2 + 88, 72, 20, GCCoreUtil.translate((String)"tile.hydroponics.plant"));
        this.updateTheButton(growStatus);
        this.field_146292_n.add(this.button);
    }

    private void updateTheButton(float growStatus) {
        if (growStatus < 0.0f) {
            this.button.field_146126_j = GCCoreUtil.translate((String)"tile.hydroponics.plant");
            ItemStack stack = this.tile.func_70301_a(1);
            this.button.field_146124_l = stack != null && stack.field_77994_a > 0 && TileEntityHydroponics.seeds.isSameItem(stack);
        } else if (growStatus < 1.0f) {
            this.button.field_146126_j = GCCoreUtil.translate((String)"tile.hydroponics.fertilize");
            ItemStack stack = this.tile.func_70301_a(1);
            this.button.field_146124_l = stack != null && stack.field_77994_a > 0 && TileEntityHydroponics.bonemeal.isSameItem(stack);
        } else {
            this.button.field_146126_j = GCCoreUtil.translate((String)"tile.hydroponics.harvest");
            this.button.field_146124_l = true;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        float growStatus = this.tile.getPlantGrowthStatus();
        this.field_146289_q.func_78276_b(this.tile.func_145825_b(), 8, 10, 0x404040);
        GCCoreUtil.drawStringRightAligned((String)(GCCoreUtil.translate((String)"gui.message.out.name") + ":"), (int)99, (int)25, (int)0x404040, (FontRenderer)this.field_146289_q);
        GCCoreUtil.drawStringRightAligned((String)(GCCoreUtil.translate((String)"gui.message.in.name") + ":"), (int)99, (int)37, (int)0x404040, (FontRenderer)this.field_146289_q);
        String plantStatus = this.getPlantStatus(growStatus);
        if (growStatus < 0.0f) {
            GCCoreUtil.drawStringCentered((String)(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + plantStatus), (int)(this.field_146999_f / 2), (int)50, (int)0x404040, (FontRenderer)this.field_146289_q);
        } else {
            GCCoreUtil.drawStringCentered((String)(GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus()), (int)(this.field_146999_f / 2), (int)50, (int)0x404040, (FontRenderer)this.field_146289_q);
            GCCoreUtil.drawStringCentered((String)(GCCoreUtil.translate((String)"tile.hydroponics.plantstatus") + ": " + plantStatus), (int)(this.field_146999_f / 2), (int)60, (int)0x404040, (FontRenderer)this.field_146289_q);
            String status = GCCoreUtil.translate((String)"gui.status.collecting.name") + ": " + (int)(0.5f + Math.min(this.tile.lastOxygenCollected * 20.0f, 2000.0f)) + GCCoreUtil.translate((String)"gui.perSecond");
            GCCoreUtil.drawStringCentered((String)status, (int)(this.field_146999_f / 2), (int)70, (int)0x404040, (FontRenderer)this.field_146289_q);
        }
        this.updateTheButton(growStatus);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 90 + 2, 0x404040);
    }

    private String getPlantStatus(float growStatus) {
        if (growStatus < 0.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"tile.hydroponics.noplant");
        }
        if (growStatus < 1.0f) {
            return EnumColor.YELLOW.getCode() + String.format("%.1f", Float.valueOf(this.tile.getPlantGrowthStatus() * 100.0f)) + "%";
        }
        return EnumColor.DARK_GREEN + "100%";
    }

    private String getStatus() {
        return this.tile.getGUIstatus();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile != null) {
            int scale = this.tile.getCappedScaledOxygenLevel(54);
            this.func_73729_b(x + 113, y + 25, 197, 7, Math.min(scale, 54), 7);
            scale = this.tile.getScaledElecticalLevel(54);
            this.func_73729_b(x + 113, y + 38, 197, 0, Math.min(scale, 54), 7);
            if (this.tile.getEnergyStoredGC() > 0.0f) {
                this.func_73729_b(x + 99, y + 37, 176, 0, 11, 10);
            }
            if (this.tile.storedOxygen > 0.0f) {
                this.func_73729_b(x + 100, y + 24, 187, 0, 10, 10);
            }
            ArrayList<String> oxygenDesc = new ArrayList<String>();
            oxygenDesc.add(GCCoreUtil.translate((String)"gui.oxygenStorage.desc.0"));
            oxygenDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.tile.storedOxygen) + " / " + (int)Math.floor(this.tile.maxOxygen));
            this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
            ArrayList<String> electricityDesc = new ArrayList<String>();
            electricityDesc.add(GCCoreUtil.translate((String)"gui.energyStorage.desc.0"));
            EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
            this.electricInfoRegion.tooltipStrings = electricityDesc;
        }
    }
}

