/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world;

import de.katzenpapst.amunra.helper.CoordHelper;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;

public class TerrainGenerator {
    protected final Gradient noiseGenBase;
    protected final Gradient noiseGenSmallHill;
    protected final Gradient noiseGenMountain;
    protected final Gradient noiseGenFeature;
    protected final Gradient noiseGenLargeFilter;
    protected final Gradient noiseGenValley;
    protected final Gradient noiseGenSmallFilter;
    protected final float heightModifier;
    protected final float smallFeatureHeightModifier;
    protected final double mountainHeightMod;
    protected final double valleyHeightMod;
    protected final double seaLevel;
    protected final float mainFeatureFilterMod;
    protected final float largeFeatureFilterMod;
    protected final float smallFeatureFilterMod;
    protected final BlockMetaPair stoneBlock;
    protected final BlockMetaPair airBlock;
    protected final int maxHeight;
    protected Random rand;

    public TerrainGenerator(Random rand, BlockMetaPair stoneBlock, BlockMetaPair airBlock, float heightMod, float smallFeatureMod, double mountainHeightMod, double valleyHeightMod, double seaLevel, int maxHeight, float mainFeatureFilterMod, float largeFeatureFilterMod, float smallFeatureFilterMod) {
        this.rand = rand;
        this.stoneBlock = stoneBlock;
        this.airBlock = airBlock;
        this.maxHeight = maxHeight;
        this.noiseGenBase = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGenSmallHill = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGenMountain = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGenValley = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.noiseGenFeature = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGenLargeFilter = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGenSmallFilter = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.heightModifier = heightMod;
        this.smallFeatureHeightModifier = smallFeatureMod;
        this.valleyHeightMod = valleyHeightMod;
        this.seaLevel = seaLevel;
        this.mountainHeightMod = mountainHeightMod;
        this.mainFeatureFilterMod = mainFeatureFilterMod;
        this.largeFeatureFilterMod = largeFeatureFilterMod;
        this.smallFeatureFilterMod = smallFeatureFilterMod;
    }

    public TerrainGenerator(Random rand, BlockMetaPair stoneBlock, BlockMetaPair airBlock, float heightMod, float smallFeatureMod, double mountainHeightMod, double valleyHeightMod, double seaLevel, int maxHeight) {
        this(rand, stoneBlock, airBlock, heightMod, smallFeatureMod, mountainHeightMod, valleyHeightMod, seaLevel, maxHeight, 4.0f, 8.0f, 8.0f);
    }

    public TerrainGenerator(Random rand, BlockMetaPair stoneBlock, BlockMetaPair airBlock, float heightMod, float smallFeatureMod, double mountainHeightMod, double valleyHeightMod, double seaLevel) {
        this(rand, stoneBlock, airBlock, heightMod, smallFeatureMod, mountainHeightMod, valleyHeightMod, seaLevel, 255, 4.0f, 8.0f, 8.0f);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.noiseGenBase.setFrequency(0.015f);
        this.noiseGenSmallHill.setFrequency(0.01f);
        this.noiseGenMountain.setFrequency(0.01f);
        this.noiseGenValley.setFrequency(0.01f);
        this.noiseGenFeature.setFrequency(0.01f);
        this.noiseGenLargeFilter.setFrequency(0.001f);
        this.noiseGenSmallFilter.setFrequency(0.005f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double baseHeight = this.noiseGenBase.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.heightModifier;
                double smallHillHeight = this.noiseGenSmallHill.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.smallFeatureHeightModifier;
                double mountainHeight = Math.abs(this.noiseGenMountain.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.noiseGenValley.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = this.noiseGenFeature.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.mainFeatureFilterMod;
                double largeFilter = this.noiseGenLargeFilter.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.largeFeatureFilterMod;
                double smallFilter = (double)(this.noiseGenSmallFilter.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.smallFeatureFilterMod) - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.mountainHeightMod, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.valleyHeightMod - this.valleyHeightMod + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                for (int y = 0; y <= this.maxHeight; ++y) {
                    int index = CoordHelper.getIndex(x, y, z);
                    if ((double)y < this.seaLevel + yDev) {
                        idArray[index] = this.stoneBlock.getBlock();
                        metaArray[index] = this.stoneBlock.getMetadata();
                        continue;
                    }
                    idArray[index] = this.airBlock.getBlock();
                    metaArray[index] = this.airBlock.getMetadata();
                }
            }
        }
    }

    protected double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    protected double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    protected double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }
}

