/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.village;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.populator.TouchSolarPanel;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageComponent;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageStart;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SolarField
extends GridVillageComponent {
    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] blocks, byte[] metas) {
        StructureBoundingBox chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        int fallbackGround = this.parent.getWorldGroundLevel();
        if (this.groundLevel == -1) {
            this.groundLevel = SolarField.getAverageGroundLevel(blocks, metas, this.getStructureBoundingBox(), chunkBB, fallbackGround);
            if (this.groundLevel == -1) {
                this.groundLevel = fallbackGround;
            }
        }
        StructureBoundingBox myBB = this.getStructureBoundingBox();
        BlockMetaPair floor = ((GridVillageStart)this.parent).getFloorMaterial();
        BlockMetaPair padding = ((GridVillageStart)this.parent).getFillMaterial();
        boolean startX = false;
        int stopX = myBB.func_78883_b();
        boolean startZ = false;
        int stopZ = myBB.func_78880_d();
        int zCenter = (int)Math.ceil((stopZ - 0) / 2 + 0);
        int aluWireMetadata = AmunRa.config.villageAdvancedMachines ? 1 : 0;
        for (int x = 0; x < stopX; ++x) {
            for (int z = 0; z < stopZ; ++z) {
                int y;
                int highestGroundBlock = this.getHighestSolidBlockInBB(blocks, metas, chunkX, chunkZ, x, z);
                if (highestGroundBlock == -1) continue;
                for (y = highestGroundBlock - 1; y < this.groundLevel; ++y) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, padding);
                }
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel - 1, z, floor);
                for (y = this.groundLevel; y < 255; ++y) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, Blocks.field_150350_a, 0);
                }
                if (x == 2 || x == stopX - 3) {
                    if (z == 2) {
                        this.placeSolarPanel(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, 0);
                        continue;
                    }
                    if (z == stopZ - 3) {
                        this.placeSolarPanel(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, 1);
                        continue;
                    }
                    if (z <= 2 || z >= stopZ - 3) continue;
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, GCBlocks.aluminumWire, aluWireMetadata);
                    continue;
                }
                if (z == zCenter && x > 2 && x < stopX - 3) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, GCBlocks.aluminumWire, aluWireMetadata);
                    continue;
                }
                if (x != 1 || z != zCenter) continue;
                int storageMetadata = SolarField.rotateStandardMetadata(2, this.coordMode);
                if (AmunRa.config.villageAdvancedMachines) {
                    storageMetadata |= 8;
                }
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, GCBlocks.machineTiered, storageMetadata);
            }
        }
        return true;
    }

    private void placeSolarPanel(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int y, int z, int meta) {
        int rotationMetadata = SolarField.rotateStandardMetadata(meta, this.coordMode);
        if (AmunRa.config.villageAdvancedMachines) {
            rotationMetadata |= 4;
        }
        if (this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, GCBlocks.solarPanel, rotationMetadata)) {
            this.parent.addPopulator(new TouchSolarPanel(this.getXWithOffset(x, z), this.groundLevel, this.getZWithOffset(x, z)));
        }
    }
}

