/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.features.trees;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.world.features.trees.WorldGenBOPShrub;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenRedwoodTree2
extends WorldGenAbstractTree {
    private final Block wood;
    private final Block leaves;
    private final int woodMeta;
    private final int leavesMeta;
    private final int minTreeHeight;
    private final int randomTreeHeight;

    public WorldGenRedwoodTree2(Block wood, Block leaves, int woodMeta, int leavesMeta, boolean doBlockNotify, int minTreeHeight, int randomTreeHeight) {
        super(doBlockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.woodMeta = woodMeta;
        this.leavesMeta = leavesMeta;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int treeHeight = random.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        if (y >= 1 && y + treeHeight + 1 <= 256) {
            Block block2;
            int iz;
            int ix;
            boolean isSoil = true;
            boolean hasSpace = true;
            block0: for (ix = -2; ix <= 2 && isSoil; ++ix) {
                for (iz = -2; iz <= 2; ++iz) {
                    block2 = world.func_147439_a(x + ix, y - 1, z + iz);
                    if (block2.canSustainPlant((IBlockAccess)world, x + ix, y - 1, z + iz, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                    isSoil = false;
                    continue block0;
                }
            }
            for (ix = -2; ix <= 2 && hasSpace; ++ix) {
                block3: for (int iy = 0; iy <= treeHeight && hasSpace; ++iy) {
                    for (int iz2 = -2; iz2 <= 2; ++iz2) {
                        Block block22 = world.func_147439_a(x + ix, y + iy, z + iz2);
                        if (block22.isAir((IBlockAccess)world, x + ix, y + iy, z + iz2)) continue;
                        hasSpace = false;
                        continue block3;
                    }
                }
            }
            if (isSoil && hasSpace && y < 256 - treeHeight - 1) {
                int k1;
                for (ix = -2; ix <= 2; ++ix) {
                    for (iz = -2; iz <= 2; ++iz) {
                        if ((ix == -2 || ix == 2) && iz != 0 || (iz == -2 || iz == 2) && ix != 0) continue;
                        block2 = world.func_147439_a(x + ix, y - 1, z + iz);
                        block2.onPlantGrow(world, x + ix, y - 1, z + iz, x + ix, y - 1, z + iz);
                    }
                }
                int width = 9;
                int b1 = 0;
                for (k1 = y - width + treeHeight; k1 <= y + treeHeight; ++k1) {
                    int i3 = k1 - (y + treeHeight);
                    int l1 = b1 + 1 - i3 / 6;
                    for (int i2 = x - l1; i2 <= x + l1; ++i2) {
                        int j2 = i2 - x;
                        for (int k2 = z - l1; k2 <= z + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - z;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (random.nextInt(2) == 0 || i3 == 0) || !(block1 = world.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)world, i2, k1, k2) && !block1.isLeaves((IBlockAccess)world, i2, k1, k2)) continue;
                            this.func_150516_a(world, i2, k1 + 6, k2, this.leaves, this.leavesMeta);
                            this.func_150516_a(world, i2, k1 + 12, k2, this.leaves, this.leavesMeta);
                        }
                    }
                }
                for (k1 = 0; k1 < treeHeight; ++k1) {
                    Block block = world.func_147439_a(x, y + k1, z);
                    if (!block.isAir((IBlockAccess)world, x, y + k1, z) && !block.isLeaves((IBlockAccess)world, x, y + k1, z)) continue;
                    this.func_150516_a(world, x, y + treeHeight, z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + (treeHeight + 1), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + (treeHeight + 2), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + (treeHeight + 3), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + (treeHeight + 4), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + (treeHeight + 5), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + k1, z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x - 1, y + MathHelper.func_76128_c((double)((double)k1 * 0.75)), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x + 1, y + MathHelper.func_76128_c((double)((double)k1 * 0.75)), z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + MathHelper.func_76128_c((double)((double)k1 * 0.75)), z - 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + MathHelper.func_76128_c((double)((double)k1 * 0.75)), z + 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x - 1, y + k1 / 2, z - 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x + 1, y + k1 / 2, z - 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x - 1, y + k1 / 2, z + 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x + 1, y + k1 / 2, z + 1, this.wood, this.woodMeta);
                    this.func_150516_a(world, x - 2, y + k1 / 4, z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x + 2, y + k1 / 4, z, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + k1 / 4, z - 2, this.wood, this.woodMeta);
                    this.func_150516_a(world, x, y + k1 / 4, z + 2, this.wood, this.woodMeta);
                }
                for (int i = 0; i < 90; ++i) {
                    int randX = x - random.nextInt(8) + random.nextInt(8);
                    int randY = y + random.nextInt(64);
                    int randZ = z - random.nextInt(8) + random.nextInt(8);
                    new WorldGenBOPShrub(BOPCBlocks.logs3, BOPCBlocks.colorizedLeaves1, 0, 3, BOPCBlocks.logs3).func_76484_a(world, random, randX, randY, randZ);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

