/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.item;

import cpw.mods.fml.common.FMLLog;
import java.util.List;
import java.util.Random;
import net.fuzzycraft.botanichorizons.addons.item.ItemDisassemblyWrench;
import net.fuzzycraft.botanichorizons.addons.item.ItemSuperchargedWrench;
import net.fuzzycraft.botanichorizons.util.BlockBreakHelper;
import net.fuzzycraft.botanichorizons.util.BlockPos;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloExtractor;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloScanner;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemSelectiveWrench
extends ItemSuperchargedWrench {
    public static final String ITEM_ID = "elvenDisassemblyWrench";
    public static final int TOOL_MINING_LEVEL = 3;
    public static final String TAG_BLOCK = "block";
    private static final Random dropRandom = new Random();

    public ItemSelectiveWrench(Item.ToolMaterial toolMaterial) {
        super(toolMaterial, 3, ITEM_ID);
    }

    @Override
    public void func_77624_a(ItemStack heldItem, EntityPlayer player, List<String> tooltips, boolean par4) {
        super.func_77624_a(heldItem, player, tooltips, par4);
        tooltips.add(I18n.func_135052_a((String)"botanichorizons.tooltip.disassembly.rightClick", (Object[])new Object[0]));
        tooltips.add(I18n.func_135052_a((String)"botanichorizons.tooltip.disassembly.shiftRightClick", (Object[])new Object[0]));
    }

    public boolean onItemUseFirst(ItemStack heldItem, EntityPlayer player, World world, int blockX, int blockY, int blockZ, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return this.selectBlock(heldItem, player, world, blockX, blockY, blockZ);
        }
        NBTTagCompound matchItem = ItemNBTHelper.getCompound((ItemStack)heldItem, (String)TAG_BLOCK, (boolean)true);
        if (matchItem == null) {
            return true;
        }
        ItemStack blockStack = ItemStack.func_77949_a((NBTTagCompound)matchItem);
        if (blockStack == null) {
            FMLLog.warning((String)"Invalid ItemStack detected #1: %s", (Object[])new Object[]{matchItem.toString()});
            return true;
        }
        Item wrappedItem = blockStack.func_77973_b();
        if (!(wrappedItem instanceof ItemBlock)) {
            FMLLog.warning((String)"Invalid ItemStack detected #2: %s", (Object[])new Object[]{matchItem.toString()});
            return true;
        }
        Block scanBlock = ((ItemBlock)wrappedItem).field_150939_a;
        int scanMeta = blockStack.func_77960_j();
        if (scanBlock == null) {
            FMLLog.warning((String)"Invalid ItemStack detected #3: %s", (Object[])new Object[]{matchItem.toString()});
            return true;
        }
        TileEntity blockTileEntity = world.func_147438_o(blockX, blockY, blockZ);
        if (blockTileEntity == null) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.missingConstruct", new Object[0]));
            return true;
        }
        return this.onItemUseTileEntity(blockTileEntity, heldItem, player, world, side, scanBlock, scanMeta);
    }

    private <T extends TileEntity> boolean onItemUseTileEntity(T tileEntity, ItemStack heldItem, EntityPlayer player, World world, int side, Block scanBlock, int scanMeta) {
        if (!world.field_72995_K) {
            int startPos;
            HoloScanner scanner = HoloExtractor.scanTileEntity(tileEntity, side);
            if (scanner == null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.missingConstruct", new Object[0]));
                return true;
            }
            int break_capacity = ItemDisassemblyWrench.DISASSEMBLY_PARALLELS[this.getLevel(heldItem)];
            int slot = startPos = ItemDisassemblyWrench.resumePos % scanner.multiblockLocations.size();
            int break_capacity_remaining = break_capacity;
            while (break_capacity_remaining > 0) {
                int blockMeta;
                slot = (slot + 1) % scanner.multiblockLocations.size();
                BlockPos pos = scanner.multiblockLocations.get(slot);
                if (slot == startPos) break;
                Block block = world.func_147439_a(pos.x, pos.y, pos.z);
                if (block != scanBlock || (blockMeta = world.func_72805_g(pos.x, pos.y, pos.z)) != scanMeta) continue;
                if (BlockBreakHelper.tryBreakWrenchable(world, player, pos.x, pos.y, pos.z, block, blockMeta, player.field_70165_t, player.field_70163_u, player.field_70161_v)) {
                    --break_capacity_remaining;
                    continue;
                }
                if (BlockBreakHelper.tryBreakHeldTool(world, player, pos.x, pos.y, pos.z, block, blockMeta, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropRandom)) {
                    --break_capacity_remaining;
                    continue;
                }
                FMLLog.warning((String)"Can't actually disassemble block: %s:%d", (Object[])new Object[]{block.func_149739_a(), blockMeta});
            }
            ItemDisassemblyWrench.resumePos = slot;
            int broken_blocks = break_capacity - break_capacity_remaining;
            this.damageOrConsumeMana(heldItem, (EntityLivingBase)player, broken_blocks, 150);
            if (broken_blocks == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.complete", new Object[0]));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.amount", new Object[]{"" + broken_blocks}));
            }
            return true;
        }
        if (HoloExtractor.isProbablyConstructable(tileEntity)) {
            return false;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"botanichorizons.chat.disassembly.missingConstruct", (Object[])new Object[0])));
        return true;
    }

    private boolean selectBlock(ItemStack heldItem, EntityPlayer player, World world, int blockX, int blockY, int blockZ) {
        Block selectedBlock = world.func_147439_a(blockX, blockY, blockZ);
        int selectedMeta = world.func_72805_g(blockX, blockY, blockZ);
        if (!BlockBreakHelper.isWrenchableBlock(selectedBlock, player) && !BlockBreakHelper.isBlockBreakableWithHeldTool(selectedBlock, selectedMeta, player)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"botanichorizons.chat.disassembly.notWrenchable", (Object[])new Object[0])));
            return true;
        }
        ItemStack selection = new ItemStack(selectedBlock, 1, selectedMeta);
        NBTTagCompound savedItem = new NBTTagCompound();
        selection.func_77955_b(savedItem);
        ItemNBTHelper.setCompound((ItemStack)heldItem, (String)TAG_BLOCK, (NBTTagCompound)savedItem);
        return false;
    }
}

