/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.gui.container;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotSecure;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.gui.widgets.Widget;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.railcraft.gui.slot.PaperSlotFilter;
import pl.asie.computronics.integration.railcraft.gui.slot.SlotSecureInput;
import pl.asie.computronics.integration.railcraft.gui.widget.LockButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.PrintButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.ProgressBarWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.SlotSelectionWidget;
import pl.asie.computronics.integration.railcraft.tile.TileTicketMachine;
import pl.asie.computronics.reference.Config;

public class ContainerTicketMachine
extends RailcraftContainer {
    private final InventoryPlayer inventoryPlayer;
    private final RFEnergyIndicator energyIndicator;
    private final TileTicketMachine tile;
    private boolean maintenanceMode = false;
    private boolean isSelectLocked = true;
    public boolean canLock;
    private int lastEnergy;
    private int lastProgress;

    public ContainerTicketMachine(InventoryPlayer inventoryPlayer, TileTicketMachine tile, boolean maintenanceMode) {
        super((IInventory)inventoryPlayer);
        int j;
        int i;
        this.inventoryPlayer = inventoryPlayer;
        this.tile = tile;
        this.maintenanceMode = maintenanceMode;
        this.addWidget(new PrintButtonWidget(tile, 67, 54, 0, 168, 20, 16));
        this.addWidget(new SlotSelectionWidget(tile, 33, 15, 184, 0, 88, 34, maintenanceMode));
        this.energyIndicator = new RFEnergyIndicator(tile.getMaxEnergyStored(ForgeDirection.UNKNOWN));
        if (Config.TICKET_MACHINE_CONSUME_RF) {
            this.addWidget(new Widget(160, 14, 184, 25, 8, 50));
            this.addWidget((Widget)new IndicatorWidget((IIndicatorController)this.energyIndicator, 161, 15, 194, 26, 6, 48));
        }
        this.addWidget(new ProgressBarWidget(tile, 136, 34, 208, 25, 10, 13));
        if (maintenanceMode) {
            this.addWidget(new LockButtonWidget(tile, 6, 6, 224, 0, 16, 16, true));
        } else {
            this.addWidget(new LockButtonWidget(tile, 6, 6, 224, 0, 16, 16, false));
        }
        for (i = 0; i < 5; ++i) {
            this.addSlot((Slot)new SlotSecure(ItemTicketGold.FILTER, (IInventory)tile, i, 33 + i * 18, 15));
        }
        for (i = 0; i < 5; ++i) {
            this.addSlot((Slot)new SlotSecure(ItemTicketGold.FILTER, (IInventory)tile, i + 5, 33 + i * 18, 33));
        }
        this.addSlot((Slot)new SlotSecureInput(PaperSlotFilter.FILTER, (IInventory)tile, 10, 133, 15));
        this.addSlot((Slot)new SlotOutput((IInventory)tile, 11, 133, 54));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryPlayer, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryPlayer, j, 8 + j * 18, 142));
        }
        this.setTicketsAndPaperLocked(!this.maintenanceMode());
    }

    public boolean maintenanceMode() {
        return this.maintenanceMode;
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        if (!this.maintenanceMode()) {
            this.setTicketsAndPaperLocked(true);
        } else {
            this.setTicketsAndPaperLocked(false);
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public void setTicketsAndPaperLocked(boolean locked) {
        if (this.isSelectLocked == locked) {
            return;
        }
        for (int i = 0; i <= 10; ++i) {
            Object slot = this.field_75151_b.get(i);
            if (!(slot instanceof SlotSecure)) continue;
            ((SlotSecure)slot).locked = locked;
        }
        this.isSelectLocked = locked;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    private void updateLock() {
        for (Widget widget : this.getElements()) {
            if (!(widget instanceof LockButtonWidget)) continue;
            ((LockButtonWidget)widget).accessible = this.maintenanceMode() && this.canLock;
        }
    }

    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (Object crafter : this.field_75149_d) {
            if (!(crafter instanceof ICrafting)) continue;
            if (this.lastEnergy != this.tile.getEnergyStored(ForgeDirection.UNKNOWN)) {
                ((ICrafting)crafter).func_71112_a((Container)this, 2, this.tile.getEnergyStored(ForgeDirection.UNKNOWN));
            }
            if (this.lastProgress == this.tile.getProgress()) continue;
            ((ICrafting)crafter).func_71112_a((Container)this, 3, this.tile.getProgress());
        }
        this.lastProgress = this.tile.getProgress();
        this.lastEnergy = this.tile.getEnergyStored(ForgeDirection.UNKNOWN);
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        this.canLock = PlayerPlugin.isOwnerOrOp((GameProfile)this.tile.getOwner(), (GameProfile)this.inventoryPlayer.field_70458_d.func_146103_bH());
        this.updateLock();
        player.func_71112_a((Container)this, 0, this.canLock ? 1 : 0);
        player.func_71112_a((Container)this, 2, this.tile.getEnergyStored(ForgeDirection.UNKNOWN));
        player.func_71112_a((Container)this, 3, this.tile.getProgress());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 0: {
                this.canLock = value == 1;
                this.updateLock();
                break;
            }
            case 1: {
                this.energyIndicator.updateEnergy(value);
                break;
            }
            case 2: {
                this.energyIndicator.setEnergy(value);
                break;
            }
            case 3: {
                this.tile.setProgress(value);
            }
        }
    }
}

