/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.container.ContainerPlayerDetector;
import com.brandon3055.draconicevolution.common.network.PlayerDetectorButtonPacket;
import com.brandon3055.draconicevolution.common.network.PlayerDetectorStringPacket;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIPlayerDetector
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/PlayerDetector.png");
    private final ContainerPlayerDetector container;
    private boolean isInEditMode = false;
    private int range = 0;
    private boolean isInWhitelistMode = false;
    private boolean isOutputInverted = false;
    private boolean isInitScheduled = false;
    private int initTick = 0;
    private final String[] names = new String[42];
    private GuiTextField selectedNameText;
    private int selectedMameIndex = -1;

    public GUIPlayerDetector(InventoryPlayer playerInventory, TilePlayerDetectorAdvanced detector) {
        super(detector.getGuiContainer(playerInventory));
        this.container = (ContainerPlayerDetector)this.field_147002_h;
        Arrays.fill(this.names, "");
        this.field_146999_f = 176;
        this.field_147000_g = 198;
        this.syncWithServer();
    }

    protected void func_146976_a(float partialTicks, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.isInEditMode) {
            this.func_73729_b(this.field_147003_i + 3, this.field_147009_r + this.field_147000_g / 2, 3, 3, this.field_146999_f - 6, this.field_147000_g / 2 - 3);
            this.drawNameChart(x, y);
        }
        if (this.container.shouldShowInventory()) {
            this.func_73729_b(this.field_147003_i + 142, this.field_147009_r + 19, this.field_146999_f, 0, 23, 41);
        }
    }

    protected void func_146979_b(int x, int y) {
        this.drawGuiText();
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        super.func_73863_a(x, y, partialTicks);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camouflage");
        if (x - this.field_147003_i > 142 && x - this.field_147003_i < 160 && y - this.field_147009_r > 19 && y - this.field_147009_r < 37 && this.container.shouldShowInventory()) {
            this.drawHoveringText(lines, x, y, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (!this.isInEditMode) {
            String mode = this.isInWhitelistMode ? "White List" : "Black List";
            int center = this.field_146294_l / 2;
            this.field_146292_n.add(new GuiButton(0, center - 20 - 20, this.field_147009_r + 20, 20, 20, "+"));
            this.field_146292_n.add(new GuiButton(1, center + 20, this.field_147009_r + 20, 20, 20, "-"));
            this.field_146292_n.add(new GuiButton(3, center - 40, this.field_147009_r + 45, 60, 20, mode));
            this.field_146292_n.add(new GuiButton(4, center + 20, this.field_147009_r + 45, 20, 20, "!"));
            this.field_146292_n.add(new GuiButton(6, center - 40, this.field_147009_r + 70, 80, 20, "Invert Output"));
        } else {
            this.field_146292_n.add(new GuiButton(5, this.field_147003_i - 40, this.field_147009_r + this.field_147000_g - 20, 40, 20, "Back"));
        }
        this.selectedNameText = new GuiTextField(this.field_146289_q, 4, -12, 168, 12);
        this.selectedNameText.func_146193_g(-1);
        this.selectedNameText.func_146204_h(-1);
        this.selectedNameText.func_146185_a(true);
        this.selectedNameText.func_146203_f(40);
        this.selectedNameText.func_146189_e(this.isInEditMode);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.range = Math.min(this.range + 1, 20);
                DraconicEvolution.network.sendToServer((IMessage)new PlayerDetectorButtonPacket(0, (byte)this.range));
                break;
            }
            case 1: {
                this.range = Math.max(this.range - 1, 1);
                DraconicEvolution.network.sendToServer((IMessage)new PlayerDetectorButtonPacket(0, (byte)this.range));
                break;
            }
            case 3: {
                this.isInitScheduled = true;
                this.isInEditMode = true;
                this.container.setShouldShowInventory(false);
                break;
            }
            case 4: {
                this.isInitScheduled = true;
                this.isInWhitelistMode = !this.isInWhitelistMode;
                byte whitelistMode = (byte)(this.isInWhitelistMode ? 1 : 0);
                DraconicEvolution.network.sendToServer((IMessage)new PlayerDetectorButtonPacket(1, whitelistMode));
                break;
            }
            case 5: {
                this.isInitScheduled = true;
                this.isInEditMode = false;
                this.container.setShouldShowInventory(true);
                break;
            }
            case 6: {
                this.isInitScheduled = true;
                this.isOutputInverted = !this.isOutputInverted;
                byte outputMode = (byte)(this.isOutputInverted ? 1 : 0);
                DraconicEvolution.network.sendToServer((IMessage)new PlayerDetectorButtonPacket(2, outputMode));
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.selectedNameText.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (keyCode == 28) {
            if (this.selectedNameText.func_146206_l()) {
                this.names[this.selectedMameIndex] = this.selectedNameText.func_146179_b();
                this.selectedNameText.func_146180_a("");
                this.selectedNameText.func_146195_b(false);
                DraconicEvolution.network.sendToServer((IMessage)new PlayerDetectorStringPacket((byte)this.selectedMameIndex, this.names[this.selectedMameIndex]));
                this.selectedMameIndex = -1;
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        if (this.isInitScheduled) {
            ++this.initTick;
        }
        if (this.initTick > 1) {
            this.initTick = 0;
            this.isInitScheduled = false;
            this.func_73866_w_();
        }
        super.func_73876_c();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        if (this.isInEditMode) {
            this.selectName(x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    private void drawGuiText() {
        if (this.isInEditMode) {
            if (this.selectedMameIndex != -1) {
                this.func_73732_a(this.field_146289_q, "Press Enter to save", this.field_146999_f / 2, -22, 0xFF0000);
            }
            for (int row = 0; row < 21; ++row) {
                for (int column = 0; column < 2; ++column) {
                    if (row + column * 21 == this.selectedMameIndex) continue;
                    String name = this.names[row + column * 21];
                    if (name.length() > 13) {
                        name = name.substring(0, 13) + "...";
                    }
                    this.field_146289_q.func_78276_b(name, 5 + column * 84, 6 + row * 9, 0x980000);
                }
            }
        } else {
            this.func_73732_a(this.field_146289_q, "Advanced Player Detector", this.field_146999_f / 2, 5, 65535);
            this.field_146289_q.func_85187_a("Range:", 73, 21, 0, false);
            this.field_146289_q.func_85187_a("Output Inverted: " + this.isOutputInverted, 33, 97, 0, false);
            this.field_146289_q.func_85187_a(String.valueOf(this.range), this.range < 10 ? 85 : 82, 31, 0, false);
        }
        this.selectedNameText.func_146194_f();
    }

    private void drawNameChart(int rawX, int rawY) {
        int row;
        int x = rawX - this.field_147003_i;
        int y = rawY - this.field_147009_r;
        for (row = 0; row < 21; ++row) {
            this.func_73729_b(this.field_147003_i + 4, this.field_147009_r + 4 + row * 9, 0, this.field_147000_g, 186, 10);
        }
        for (row = 0; row < 21; ++row) {
            for (int column = 0; column < 2; ++column) {
                if ((x <= 4 + column * 84 || x >= this.field_146999_f / 2 - 1 + column * 82 || y <= 4 + row * 9 || y >= 13 + row * 9) && row + column * 21 != this.selectedMameIndex) continue;
                this.func_73729_b(this.field_147003_i + 5 + column * 84, this.field_147009_r + 5 + row * 9, 0, this.field_147000_g + 10, 82, 8);
            }
        }
    }

    public void selectName(int x, int y) {
        if (this.isInitScheduled) {
            return;
        }
        for (int row = 0; row < 21; ++row) {
            for (int column = 0; column < 2; ++column) {
                if (x <= 4 + column * 84 || x >= this.field_146999_f / 2 - 1 + column * 82 || y <= 4 + row * 9 || y >= 13 + row * 9) continue;
                this.selectedMameIndex = row + column * 21;
                this.selectedNameText.func_146180_a(this.names[row + column * 21]);
                this.selectedNameText.func_146195_b(true);
                return;
            }
        }
    }

    private void syncWithServer() {
        TilePlayerDetectorAdvanced detector = this.container.getDetector();
        this.isInWhitelistMode = detector.isInWhiteListMode;
        for (int i = 0; i < detector.names.length; ++i) {
            if (detector.names[i] == null) continue;
            this.names[i] = detector.names[i];
        }
        this.range = detector.range;
        this.isOutputInverted = detector.isOutputInverted;
    }
}

