/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.block.material.MaterialEnderGoo;
import chylex.hee.entity.GlobalMobData;
import chylex.hee.init.ItemList;
import chylex.hee.system.util.BlockPosM;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockEnderGoo
extends BlockFluidClassic {
    public static boolean shouldBattleWater = true;
    public static final Material enderGoo = new MaterialEnderGoo();
    public static final Fluid fluid = new Fluid("enderGoo").setDensity(1500).setTemperature(220).setViscosity(1500);
    private final byte[] xOff = new byte[]{-1, 1, 0, 0, 0, 0};
    private final byte[] yOff = new byte[]{0, 0, -1, 1, 0, 0};
    private final byte[] zOff = new byte[]{0, 0, 0, 0, -1, 1};
    private static final PotionEffect weakness = new PotionEffect(Potion.field_76437_t.field_76415_H, 5, 1, false);
    private static final PotionEffect miningFatigue = new PotionEffect(Potion.field_76419_f.field_76415_H, 5, 1, false);
    private static final PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 2, false);

    public BlockEnderGoo() {
        super(fluid, enderGoo);
        this.func_149649_H();
        this.setQuantaPerBlock(5);
        this.setTickRate(18);
        this.func_149675_a(true);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.func_72899_e(x - 1, y, z - 1) || !world.func_72899_e(x + 1, y, z + 1)) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            return;
        }
        super.func_149674_a(world, x, y, z, rand);
        if (shouldBattleWater) {
            BlockPosM tmpPos = BlockPosM.tmp(x, y, z);
            int meta = tmpPos.getMetadata((IBlockAccess)world);
            for (int a = 0; a < 6; ++a) {
                if (tmpPos.set(x + this.xOff[a], y + this.yOff[a], z + this.zOff[a]).getMaterial((IBlockAccess)world) != Material.field_151586_h) continue;
                if (rand.nextInt(Math.max(1, 10 - meta - (world.field_73011_w.field_76574_g == 1 ? 7 : 0) + (a == 2 || a == 3 ? 2 : 0))) == 0) {
                    tmpPos.setBlock(world, (Block)this, Math.max(2, tmpPos.getMetadata((IBlockAccess)world)));
                    if (rand.nextInt(6 - meta) != 0) continue;
                    tmpPos.setAir(world);
                    continue;
                }
                if (world.field_73011_w.field_76574_g == 1 || rand.nextInt(4) == 0) continue;
                tmpPos.set(x, y, z).setBlock(world, (Block)Blocks.field_150358_i, 2);
                for (int b = 0; b < 2 + rand.nextInt(5); ++b) {
                    int index = rand.nextInt(6);
                    if (tmpPos.set(x + this.xOff[index], y + this.yOff[index], z + this.zOff[index]).getBlock((IBlockAccess)world) != this) continue;
                    tmpPos.setBlock(world, (Block)Blocks.field_150358_i, 2);
                }
                return;
            }
        }
    }

    public void func_149640_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !GlobalMobData.isEnderGooTolerant((EntityLivingBase)entity)) {
            EntityLivingBase e = (EntityLivingBase)entity;
            e.func_70690_d(weakness);
            e.func_70690_d(miningFatigue);
            PotionEffect eff = e.func_70660_b(Potion.field_76436_u);
            if (eff == null) {
                e.func_70690_d(poison);
                eff = e.func_70660_b(Potion.field_76436_u);
                if (eff == null) {
                    return;
                }
            }
            if (eff.func_76459_b() < 102) {
                eff.func_76452_a(new PotionEffect(Potion.field_76436_u.field_76415_H, eff.func_76459_b() + 17, eff.func_76458_c(), eff.func_82720_e()));
            }
            Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            super.func_149640_a(world, x, y, z, entity, vec);
            vec.func_72432_b();
            entity.func_70024_g(vec.field_72450_a * 0.0075, vec.field_72448_b * 0.005, vec.field_72449_c * 0.0075);
            entity.field_70159_w *= 0.25;
            entity.field_70181_x *= 0.45;
            entity.field_70179_y *= 0.25;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        HardcoreEnderExpansion.fx.enderGoo(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        fluid.setIcons(this.field_149761_L);
    }

    public class EventHandler {
        @SubscribeEvent
        public void onBucketFill(FillBucketEvent e) {
            if (BlockPosM.tmp(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d).getBlock((IBlockAccess)e.world) == BlockEnderGoo.this) {
                BlockPosM.tmp(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d).setAir(e.world);
                e.result = new ItemStack(ItemList.bucket_ender_goo);
                e.setResult(Event.Result.ALLOW);
            }
        }
    }
}

