/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.bukkit.network;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import net.techbrew.journeymapserver.JMServerBukkit;
import net.techbrew.journeymapserver.bukkit.util.BukkitPlayerUtil;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.network.IPacketHandler;
import net.techbrew.journeymapserver.common.util.LogHelper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitPacketHandler
implements IPacketHandler,
PluginMessageListener {
    private static JMServerBukkit controller;

    public BukkitPacketHandler(JMServerBukkit controller) {
        BukkitPacketHandler.controller = controller;
    }

    @Override
    public void init() {
        LogHelper.info("Initializing BukkitPacketManager");
        controller.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)controller, "world_info");
        controller.getServer().getMessenger().registerIncomingPluginChannel((Plugin)controller, "world_info", (PluginMessageListener)this);
    }

    @Override
    public void sendAllPlayersWorldID(String worldID) {
        Player[] playerArray;
        for (Player player : playerArray = Bukkit.getServer().getOnlinePlayers()) {
            this.createWorldIDPacket(player, player.getWorld().getName());
        }
    }

    @Override
    public void sendPlayerWorldID(String worldID, String playerName) {
        LogHelper.info(worldID + " " + playerName);
        Player player = BukkitPlayerUtil.getPlayerByName(playerName);
        LogHelper.info(String.format("Sending WorldID to %s", player.getName()));
        this.createWorldIDPacket(player, worldID);
    }

    private void createWorldIDPacket(Player player, String worldID) {
        try {
            BukkitPacketHandler.sendData(player, (byte)0, worldID.getBytes("UTF-8"), "world_info");
        }
        catch (UnsupportedEncodingException e) {
            LogHelper.error("Bad Encoding: " + e);
        }
    }

    private static void sendData(Player player, byte packetID, byte[] data, String channel) {
        ByteBuffer buffer = ByteBuffer.allocate(2 + data.length).put(packetID).put((byte)data.length).put(data);
        player.sendPluginMessage((Plugin)controller, channel, buffer.array());
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        LogHelper.info("packet recieved " + channel);
        if (channel.equalsIgnoreCase("world_info")) {
            LogHelper.info("worldid request packet");
            this.createWorldIDPacket(player, ConfigHandler.getConfigByWorldName(player.getWorld().getName()).getWorldID());
        }
    }
}

