/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.forge.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayerMP;
import net.techbrew.journeymapserver.common.network.IPacketHandler;
import net.techbrew.journeymapserver.common.util.LogHelper;
import net.techbrew.journeymapserver.forge.network.WorldIDPacket;
import net.techbrew.journeymapserver.forge.util.ForgePlayerUtil;

public class ForgePacketHandler
implements IPacketHandler {
    public static final SimpleNetworkWrapper WORLD_INFO_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("world_info");

    @Override
    public void init() {
        WORLD_INFO_CHANNEL.registerMessage(WorldIDPacket.WorldIdListener.class, WorldIDPacket.class, 0, Side.SERVER);
    }

    @Override
    public void sendAllPlayersWorldID(String worldID) {
        WORLD_INFO_CHANNEL.sendToAll((IMessage)new WorldIDPacket(worldID));
    }

    @Override
    public void sendPlayerWorldID(String worldID, String playerName) {
        EntityPlayerMP player = ForgePlayerUtil.instance.getPlayerEntityByName(playerName);
        if (player instanceof EntityPlayerMP && player != null) {
            LogHelper.info(playerName + " is an EntityPlayerMP attempting to send the worldId packet");
            try {
                WORLD_INFO_CHANNEL.sendTo((IMessage)new WorldIDPacket(worldID), player);
            }
            catch (RuntimeException rte) {
                LogHelper.error(playerName + " is not a real player. WorldID:" + worldID + " Error: " + rte);
            }
            catch (Exception e) {
                LogHelper.error("Unknown Exception - PlayerName:" + playerName + " WorldID:" + worldID + " Exception " + e);
            }
        } else {
            LogHelper.info(playerName + " is not an EntityPlayerMP");
        }
    }

    private static int toInt(boolean val) {
        int intVal = val ? 1 : 0;
        return intVal;
    }
}

