/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.tooltip;

import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.AutoValue_TextFormatting;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSortedSet;
import net.minecraft.util.EnumChatFormatting;

@AutoValue
public abstract class TextFormatting {
    public static TextFormatting create(boolean small, EnumChatFormatting ... formatting) {
        return TextFormatting.builder().setSmall(small).addAllFormatting(formatting).build();
    }

    public static TextFormatting create(EnumChatFormatting ... formatting) {
        return TextFormatting.create(false, formatting);
    }

    public abstract boolean small();

    public abstract ImmutableSortedSet<EnumChatFormatting> formatting();

    public String format(String text) {
        StringBuilder builder = new StringBuilder();
        this.formatting().forEach(builder::append);
        builder.append(text);
        return builder.toString();
    }

    public static Builder builder() {
        return new AutoValue_TextFormatting.Builder().setSmall(false);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSmall(boolean var1);

        public abstract Builder setFormatting(Iterable<EnumChatFormatting> var1);

        public abstract ImmutableSortedSet.Builder<EnumChatFormatting> formattingBuilder();

        public Builder addFormatting(EnumChatFormatting formatting) {
            this.formattingBuilder().add((Object)formatting);
            return this;
        }

        public Builder addAllFormatting(EnumChatFormatting ... formatting) {
            this.formattingBuilder().add((Object[])formatting);
            return this;
        }

        public abstract TextFormatting build();
    }
}

