/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.debug.nbtviewer;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Text;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.CustomDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import com.github.dcysteine.neicustomdiagram.util.NbtUtil;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;

public final class NbtViewer
implements DiagramGenerator {
    public static final ItemComponent ICON = ItemComponent.create(Items.field_151155_ap, 0);
    private static final String SLOT_KEY = "slot";
    private final DiagramGroupInfo info;

    public NbtViewer(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.NBT_VIEWER.trans("groupname"), groupId, ICON, 1).setIgnoreNbt(false).setDefaultVisibility(DiagramGroupVisibility.DISABLED).setDescription("This diagram pretty-prints NBT, for convenient viewing.").build();
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        return new DiagramGroup(this.info, new CustomDiagramMatcher(this::generateDiagrams));
    }

    private Collection<Diagram> generateDiagrams(Interactable.RecipeType recipeType, Component component) {
        if (!component.nbt().isPresent()) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Diagram[]{Diagram.builder().addLayout(NbtViewer.buildLayout(component.nbt().get())).insertIntoSlot(Layout.SlotKey.create(SLOT_KEY), DisplayComponent.builder(component).build()).build()});
    }

    private static Layout buildLayout(NBTTagCompound nbt) {
        Layout.Builder layoutBuilder = Layout.builder();
        layoutBuilder.putSlot(Layout.SlotKey.create(SLOT_KEY), Slot.builder(Grid.GRID.grid(0, 0)).build());
        String nbtText = NbtUtil.prettyPrintNbt(nbt.toString());
        Iterable lines = Splitter.on((char)'\n').split((CharSequence)nbtText);
        layoutBuilder.addAllLabels(Text.multiLineBuilder(Grid.GRID.edge(0, 1, Grid.Direction.W), Grid.Direction.SE).setSmall(ConfigOptions.NBT_VIEWER_SMALL_TEXT.get()).addAllLines(lines).build());
        return layoutBuilder.build();
    }
}

