/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemStackSet;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NEIMouseUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiFavoriteButton
extends GuiRecipeButton {
    private static final int BUTTON_ID_START = 14;
    protected static final DrawableResource ICON_STATE_OFF = new DrawableBuilder("nei:textures/nei_sprites.png", 10, 76, 9, 10).build();
    protected static final DrawableResource ICON_STATE_ON = new DrawableBuilder("nei:textures/nei_sprites.png", 19, 76, 9, 10).build();
    protected final Recipe recipe = Recipe.of(this.handlerRef);
    protected boolean favorite = false;
    protected Recipe.RecipeIngredient favoriteResult = null;
    protected Recipe.RecipeIngredient selectedResult = null;

    public GuiFavoriteButton(RecipeHandlerRef handlerRef, int x, int y) {
        super(handlerRef, x, y, 14 + handlerRef.recipeIndex, "\u2764");
        ItemStack stack = FavoriteRecipes.getFavorite(this.recipe.getRecipeId());
        boolean bl = this.favorite = stack != null;
        if (stack == null) {
            stack = this.recipe.getResult();
        }
        for (Recipe.RecipeIngredient result : this.recipe.getResults()) {
            if (!StackInfo.equalItemAndNBT(result.getItemStack(), stack, true)) continue;
            this.favoriteResult = result;
            break;
        }
        this.field_146125_m = this.favoriteResult != null;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void toggleFavorite() {
        boolean bl = this.favorite = !this.favorite;
        if (this.selectedResult != null) {
            this.favoriteResult = this.selectedResult;
        }
        FavoriteRecipes.setFavorite(this.favoriteResult.getItemStack(), this.favorite ? this.recipe.getRecipeId() : null);
    }

    @Override
    protected void drawContent(Minecraft minecraft, int y, int x, boolean mouseOver) {
        DrawableResource icon = this.isFavorite() ? ICON_STATE_ON : ICON_STATE_OFF;
        int iconX = this.field_146128_h + (this.field_146120_f - icon.width - 1) / 2;
        int iconY = this.field_146129_i + (this.field_146121_g - icon.height) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_146124_l ? 1.0f : 0.5f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        icon.draw(iconX, iconY);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!mouseOver) {
            this.selectedResult = null;
        } else if (this.selectedResult == null) {
            this.selectedResult = this.favoriteResult;
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.toggleFavorite();
    }

    public Recipe getRecipe() {
        return Recipe.of(this.handlerRef);
    }

    @Override
    public void lastKeyTyped(char keyChar, int keyID) {
        if (NEIClientConfig.isKeyHashDown("gui.bookmark") && NEIClientUtils.shiftKey()) {
            this.saveRecipeInBookmark();
        }
    }

    @Override
    public Map<String, String> handleHotkeys(int mousex, int mousey, Map<String, String> hotkeys) {
        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("recipe.favorite.bookmark_recipe", new Object[0]));
        if (this.recipe.getResults().size() > 1) {
            hotkeys.put(NEIMouseUtils.getKeyName(-2013265920), NEIClientUtils.translate("recipe.favorite.change_result_index", new Object[0]));
        }
        return hotkeys;
    }

    @Override
    public List<String> handleTooltip(List<String> currenttip) {
        currenttip.add(NEIClientUtils.translate("recipe.favorite", new Object[0]));
        return currenttip;
    }

    @Override
    public void drawItemOverlay() {
        if (this.selectedResult == null) {
            return;
        }
        NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)this.selectedResult.relx, (int)this.selectedResult.rely, (int)16, (int)16, (int)0x66333333));
        DrawableResource icon = this.isFavorite() ? ICON_STATE_ON : ICON_STATE_OFF;
        int iconX = this.selectedResult.relx + (16 - icon.width) / 2;
        int iconY = this.selectedResult.rely + (18 - icon.height) / 2;
        LayoutManager.drawIcon(iconX, iconY, icon);
    }

    @Override
    public boolean mouseScrolled(int scroll) {
        if (this.selectedResult == null) {
            return true;
        }
        ArrayList<Recipe.RecipeIngredient> results = new ArrayList<Recipe.RecipeIngredient>(this.recipe.getResults());
        if (results.size() <= 1) {
            return true;
        }
        HashSet uniqueResults = new HashSet();
        results.removeIf(ingr -> !uniqueResults.add(StackInfo.getItemStackGUID(ingr.getItemStack())));
        int nextIndex = (results.size() - scroll + results.indexOf(this.selectedResult)) % results.size();
        this.selectedResult = (Recipe.RecipeIngredient)results.get(nextIndex);
        this.favorite = StackInfo.equalItemAndNBT(((Recipe.RecipeIngredient)results.get(nextIndex)).getItemStack(), FavoriteRecipes.getFavorite(this.recipe.getRecipeId()), true);
        return true;
    }

    public void saveRecipeInBookmark() {
        ItemPanels.bookmarkPanel.addGroup(this.getRecipesTree(this.getRecipe()), BookmarkPanel.BookmarkViewMode.TODO_LIST, true);
    }

    private List<Recipe> getRecipesTree(Recipe mainRecipe) {
        int depth = NEIClientConfig.getIntSetting("inventory.favorites.depth");
        ItemStackSet items = new ItemStackSet();
        ArrayList<Recipe> result = new ArrayList<Recipe>();
        ArrayList<Recipe> loop = new ArrayList<Recipe>();
        loop.add(mainRecipe);
        result.add(mainRecipe);
        while (!loop.isEmpty() && depth-- >= 0) {
            ArrayList<Recipe> localLoop = new ArrayList<Recipe>();
            for (Recipe localRecipe : loop) {
                for (Recipe.RecipeIngredient ingr : localRecipe.getIngredients()) {
                    List<ItemStack> permutations = ingr.getPermutations();
                    ItemStack stack = permutations.stream().filter(items::contains).findFirst().orElse(null);
                    if (stack == null) {
                        Recipe recipe;
                        stack = ingr.getItemStack();
                        Recipe.RecipeId recipeId = FavoriteRecipes.getFavorite(stack);
                        if (recipeId == null) {
                            for (ItemStack permStack : permutations) {
                                recipeId = FavoriteRecipes.getFavorite(permStack);
                                if (recipeId == null) continue;
                                stack = permStack;
                                break;
                            }
                        }
                        if ((recipe = Recipe.of(recipeId)) == null) {
                            stack = null;
                        } else {
                            items.add(stack);
                            if (depth >= 0) {
                                result.add(recipe);
                                localLoop.add(recipe);
                            }
                        }
                    }
                    if (stack == null) continue;
                    ingr.setActiveIndex(this.getIngrActiveIndex(permutations, stack));
                }
            }
            loop = localLoop;
        }
        return result;
    }

    private int getIngrActiveIndex(List<ItemStack> permutations, ItemStack stack) {
        for (int i = 0; i < permutations.size(); ++i) {
            if (!StackInfo.equalItemAndNBT(stack, permutations.get(i), true)) continue;
            return i;
        }
        return 0;
    }
}

