/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Locale;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackCoupler
extends TrackBaseRailcraft
implements ITrackPowered {
    private EntityMinecart taggedCart;
    private boolean powered = false;
    private Mode mode = Mode.COUPLER;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.COUPLER;
    }

    @Override
    public IIcon getIcon() {
        int iconIndex = 0;
        if (!this.isPowered()) {
            ++iconIndex;
        }
        return this.getIcon(iconIndex += this.mode.ordinal() * 2);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            Mode m = player.func_70093_af() ? this.mode.previous() : this.mode.next();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            if (Game.isHost(this.getWorld())) {
                this.setMode(m);
            } else {
                ChatPlugin.sendLocalizedChat(player, "railcraft.gui.track.mode.change", "\u00a75" + LocalizationPlugin.translate("railcraft.gui.track.coupler.mode." + m.getTag()));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.isPowered()) {
            this.mode.onMinecartPass(this, cart);
        }
    }

    public void setMode(Mode m) {
        if (this.mode != m) {
            this.mode = m;
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public boolean canPropagatePowerTo(ITrackInstance track) {
        if (track instanceof TrackCoupler) {
            TrackCoupler c = (TrackCoupler)track;
            return this.mode == c.mode;
        }
        return false;
    }

    @Override
    public int getPowerPropagation() {
        return this.mode.powerPropagation;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("mode", (byte)this.mode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.mode = Mode.fromOrdinal(data.func_74771_c("mode"));
        if (data.func_74767_n("decouple")) {
            this.mode = Mode.DECOUPLER;
        }
        if (data.func_74762_e("trackId") == EnumTrack.DECOUPLER.ordinal()) {
            this.mode = Mode.DECOUPLER;
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        byte m = data.readByte();
        boolean needsUpdate = false;
        if (p != this.powered) {
            this.powered = p;
            needsUpdate = true;
        }
        if (m != this.mode.ordinal()) {
            this.mode = Mode.fromOrdinal(m);
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.markBlockNeedsUpdate();
        }
    }

    static enum Mode {
        COUPLER(8){

            @Override
            public void onMinecartPass(TrackCoupler track, EntityMinecart cart) {
                CartTools.getLinkageManager(cart.field_70170_p).createLink(track.taggedCart, cart);
                track.taggedCart = cart;
            }
        }
        ,
        DECOUPLER(0){

            @Override
            public void onMinecartPass(TrackCoupler track, EntityMinecart cart) {
                CartTools.getLinkageManager(cart.field_70170_p).breakLinks(cart);
                LinkageManager.printDebug("Reason For Broken Link: Passed Decoupler Track.", new Object[0]);
            }
        }
        ,
        AUTO_COUPLER(0){

            @Override
            public void onMinecartPass(TrackCoupler track, EntityMinecart cart) {
                LinkageManager.instance().setAutoLink(cart, true);
            }
        };

        public static Mode[] VALUES;
        private int powerPropagation;

        private Mode(int powerPropagation) {
            this.powerPropagation = powerPropagation;
        }

        public static Mode fromOrdinal(int ordinal) {
            return VALUES[ordinal % VALUES.length];
        }

        public Mode next() {
            return Mode.fromOrdinal(this.ordinal() + 1);
        }

        public Mode previous() {
            return Mode.fromOrdinal(this.ordinal() + VALUES.length - 1);
        }

        public String getTag() {
            return this.name().replace('_', '.').toLowerCase(Locale.ENGLISH);
        }

        public abstract void onMinecartPass(TrackCoupler var1, EntityMinecart var2);

        static {
            VALUES = Mode.values();
        }
    }
}

