/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.ICartContentsTextureProvider;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public final class EntityCartRF
extends CartBase
implements ICartContentsTextureProvider {
    private static final int DATA_ID_RF = 25;
    private static final int RF_CAP = 2000000;

    public EntityCartRF(World world) {
        super(world);
    }

    public EntityCartRF(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int addRF(int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (this.getRF() >= 2000000) {
            return 0;
        }
        if (2000000 - this.getRF() >= amount) {
            this.setRF(this.getRF() + amount);
            return amount;
        }
        int used = 2000000 - this.getRF();
        this.setRF(2000000);
        return used;
    }

    public int removeRF(int request) {
        if (request <= 0) {
            return 0;
        }
        if (this.getRF() >= request) {
            this.setRF(this.getRF() - request);
            return request;
        }
        int ret = this.getRF();
        this.setRF(0);
        return ret;
    }

    public void setRF(int amount) {
        this.field_70180_af.func_75692_b(25, (Object)amount);
    }

    public int getRF() {
        return this.field_70180_af.func_75679_c(25);
    }

    public int getMaxRF() {
        return 2000000;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        if (this.getRF() > 2000000) {
            this.setRF(2000000);
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_RF, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    public final float getMaxCartSpeedOnRail() {
        int numLocomotives = Train.getTrain(this).getNumRunningLocomotives();
        if (numLocomotives == 0) {
            return super.getMaxCartSpeedOnRail();
        }
        return Math.min(1.2f, 0.08f + (float)(numLocomotives - 1) * 0.075f);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setRF(nbt.func_74762_e("rf"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("rf", this.getRF());
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public IIcon getBlockTextureOnSide(int side) {
        return null;
    }
}

