/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tracker;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import remoteio.common.lib.DimensionalCoords;

public class BlockTracker {
    public static final BlockTracker INSTANCE = new BlockTracker();
    private Set<TrackedBlock> trackedBlockSet = new HashSet<TrackedBlock>();

    public void startTracking(DimensionalCoords coords, ITrackerCallback callback) {
        if (coords == null || callback == null) {
            return;
        }
        this.trackedBlockSet.add(new TrackedBlock(coords, callback));
    }

    public void stopTracking(DimensionalCoords coords) {
        if (coords == null) {
            return;
        }
        for (TrackedBlock trackedBlock : this.trackedBlockSet) {
            if (!trackedBlock.coordinates.equals(coords)) continue;
            trackedBlock.setDead();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent event) {
        if (event.side == Side.SERVER && event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.END) {
            Iterator<TrackedBlock> iterator = this.trackedBlockSet.iterator();
            while (iterator.hasNext()) {
                int redstone;
                int i;
                TrackedBlock trackedBlock = iterator.next();
                if (trackedBlock.isDead) {
                    iterator.remove();
                    continue;
                }
                if (trackedBlock.coordinates.getBlock() != trackedBlock.lastBlock || trackedBlock.coordinates.getMeta() != trackedBlock.lastMeta) {
                    trackedBlock.callback();
                    trackedBlock.lastBlock = trackedBlock.coordinates.getBlock();
                    trackedBlock.lastMeta = trackedBlock.coordinates.getMeta();
                    continue;
                }
                Block block = trackedBlock.coordinates.getBlock();
                for (i = 0; i < 6; ++i) {
                    int comparator = block.func_149736_g(trackedBlock.coordinates.getWorld(), trackedBlock.coordinates.x, trackedBlock.coordinates.y, trackedBlock.coordinates.z, i);
                    if (comparator == trackedBlock.lastComparatorValue) continue;
                    trackedBlock.callback();
                    trackedBlock.lastComparatorValue = comparator;
                    break;
                }
                for (i = 0; i < 6; ++i) {
                    redstone = block.func_149709_b((IBlockAccess)trackedBlock.coordinates.getWorld(), trackedBlock.coordinates.x, trackedBlock.coordinates.y, trackedBlock.coordinates.z, i);
                    if (redstone == trackedBlock.lastWeakRedstoneValue) continue;
                    trackedBlock.callback();
                    trackedBlock.lastWeakRedstoneValue = redstone;
                }
                for (i = 0; i < 6; ++i) {
                    redstone = block.func_149748_c((IBlockAccess)trackedBlock.coordinates.getWorld(), trackedBlock.coordinates.x, trackedBlock.coordinates.y, trackedBlock.coordinates.z, i);
                    if (redstone == trackedBlock.lastStrongRedstoneValue) continue;
                    trackedBlock.callback();
                    trackedBlock.lastStrongRedstoneValue = redstone;
                }
            }
        }
    }

    public static class TrackedBlock {
        public final DimensionalCoords coordinates;
        public Block lastBlock;
        public int lastMeta;
        public int lastComparatorValue;
        public int lastWeakRedstoneValue;
        public int lastStrongRedstoneValue;
        public final ITrackerCallback callback;
        public boolean isDead = false;

        public TrackedBlock(DimensionalCoords coordinates, ITrackerCallback callback) {
            this.coordinates = coordinates;
            this.callback = callback;
        }

        public void callback() {
            this.callback.callback((IBlockAccess)this.coordinates.getWorld(), this.coordinates.x, this.coordinates.y, this.coordinates.z);
        }

        public void setDead() {
            this.isDead = true;
        }

        public int hashCode() {
            return this.coordinates.hashCode();
        }
    }

    public static interface ITrackerCallback {
        public void callback(IBlockAccess var1, int var2, int var3, int var4);
    }
}

