/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import java.util.List;
import java.util.Map;
import net.minecraft.util.IChatComponent;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.misc.MouseButton;

public class GuiViewCommands
extends GuiButtonListBase {
    private final Map<String, IChatComponent> commands;

    public GuiViewCommands(Map<String, IChatComponent> commands) {
        this.commands = commands;
        this.setHasSearchBox(true);
    }

    @Override
    public void addButtons(Panel panel) {
        this.commands.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> panel.add(new CommandEntry(panel, (String)entry.getKey(), (IChatComponent)entry.getValue())));
    }

    public static class CommandEntry
    extends SimpleTextButton {
        private final IChatComponent description;

        public CommandEntry(Panel panel, String title, IChatComponent description) {
            super(panel, title, Icon.EMPTY);
            this.description = description;
            this.setSize(16, 14);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ClientUtils.execClientCommand("/" + this.getTitle());
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.addAll(this.getGui().getTheme().listFormattedStringToWidth(this.description.func_150254_d(), 200));
        }

        @Override
        public boolean renderTitleInCenter() {
            return true;
        }
    }
}

