/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.ranks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.util.StringUtils;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class CmdInfo
extends CmdBase {
    public CmdInfo() {
        super("info", CmdBase.Level.ALL);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return Ranks.isActive() ? CmdInfo.func_71531_a((String[])args, Ranks.INSTANCE.getRankNames(false)) : Collections.emptyList();
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!Ranks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        Rank rank = Ranks.INSTANCE.getRank(sender, args[0]);
        sender.func_145747_a((IChatComponent)new ChatComponentText(""));
        ChatComponentText id = new ChatComponentText("[" + rank.getId() + (rank.comment.isEmpty() ? "]" : "] - " + rank.comment));
        id.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
        id.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, rank.getDisplayName()));
        sender.func_145747_a((IChatComponent)id);
        Set<Rank> parents = rank.getParents();
        if (!parents.isEmpty()) {
            ChatComponentText t = new ChatComponentText("");
            t.func_150257_a(StringUtils.color((IChatComponent)new ChatComponentText("parent"), EnumChatFormatting.GOLD));
            t.func_150258_a(": ");
            boolean first = true;
            for (Rank r : parents) {
                if (first) {
                    first = false;
                } else {
                    t.func_150258_a(", ");
                }
                ChatComponentText t1 = new ChatComponentText(r.getId());
                t1.func_150256_b().func_150238_a(EnumChatFormatting.AQUA);
                if (!r.comment.isEmpty()) {
                    t1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(r.comment)));
                }
                t1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ranks info " + r.getId()));
                t.func_150257_a((IChatComponent)t1);
            }
            sender.func_145747_a((IChatComponent)t);
        }
        for (Rank.Entry entry : rank.permissions.values()) {
            if (entry.node.equals("parent")) continue;
            ChatComponentText t = new ChatComponentText("");
            t.func_150257_a(StringUtils.color((IChatComponent)new ChatComponentText(entry.node), EnumChatFormatting.GOLD));
            t.func_150258_a(": ");
            t.func_150257_a(StringUtils.color((IChatComponent)new ChatComponentText(entry.value), EnumChatFormatting.BLUE));
            if (!entry.comment.isEmpty()) {
                t.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(entry.comment)));
            }
            t.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ranks set_permission " + rank.getId() + " " + entry.node + " " + entry.value));
            sender.func_145747_a((IChatComponent)t);
        }
    }
}

