/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.data.TeleportLog;
import serverutils.data.TeleportType;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.INBTSerializable;
import serverutils.lib.util.permission.IPermissionHandler;
import serverutils.lib.util.permission.PermissionAPI;

public class TeleportTracker
implements INBTSerializable<NBTTagCompound> {
    private final TeleportLog[] logs = new TeleportLog[TeleportType.values().length];
    private final IPermissionHandler permissionHandler;

    public TeleportTracker() {
        this(PermissionAPI.getPermissionHandler());
    }

    public TeleportTracker(IPermissionHandler permissionHandler) {
        this.permissionHandler = permissionHandler;
    }

    public void logTeleport(TeleportType teleportType, BlockDimPos from, long worldTime) {
        this.logs[teleportType.ordinal()] = new TeleportLog(teleportType, from, worldTime);
    }

    public TeleportLog getLastDeath() {
        return this.logs[TeleportType.RESPAWN.ordinal()];
    }

    private TeleportLog[] getSortedLogs() {
        TeleportLog[] toSort = (TeleportLog[])Arrays.stream(this.logs).filter(Objects::nonNull).toArray(TeleportLog[]::new);
        Arrays.sort(toSort, Collections.reverseOrder());
        return toSort;
    }

    public TeleportLog getLastAvailableLog(GameProfile gameProfile) {
        for (TeleportLog l : this.getSortedLogs()) {
            if (!this.permissionHandler.hasPermission(gameProfile, l.teleportType.getPermission(), null)) continue;
            return l;
        }
        return null;
    }

    public TeleportLog getLastLog() {
        TeleportLog[] logs = this.getSortedLogs();
        return logs[0];
    }

    public long getLastTeleportTime(TeleportType teleportType) {
        TeleportLog log = this.logs[teleportType.ordinal()];
        return log == null ? -1L : log.getCreatedAt();
    }

    public void clearLog(TeleportType teleportType) {
        this.logs[teleportType.ordinal()] = null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.logs.length; ++i) {
            if (this.logs[i] == null) continue;
            nbt.func_74782_a(String.valueOf(i), (NBTBase)this.logs[i].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.logs.length; ++i) {
            String key = String.valueOf(i);
            if (!nbt.func_74764_b(key)) continue;
            this.logs[i] = new TeleportLog(nbt.func_74775_l(key));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int i = 0; i < this.logs.length; ++i) {
            TeleportLog l = this.logs[i];
            builder.append(l.teleportType.toString()).append(":").append(l.getBlockDimPos());
            if (i == this.logs.length - 1) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

