/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.math;

import net.minecraft.util.EnumFacing;

public enum SidedDirection {
    BOTTOM(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.DOWN, EnumFacing.DOWN, EnumFacing.DOWN),
    TOP(EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP),
    BACK(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST),
    FRONT(EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST),
    LEFT(EnumFacing.WEST, EnumFacing.EAST, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH),
    RIGHT(EnumFacing.EAST, EnumFacing.WEST, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH);

    public static final SidedDirection[] VALUES;
    public final EnumFacing[] directions;
    private static final SidedDirection[] CACHED_SIDES;

    private SidedDirection(EnumFacing a, EnumFacing b, EnumFacing c, EnumFacing d, EnumFacing e, EnumFacing f) {
        this.directions = new EnumFacing[]{a, b, c, d, e, f};
    }

    public static SidedDirection getSide(EnumFacing side, EnumFacing rot) {
        return CACHED_SIDES[side.ordinal() + rot.ordinal() * 6];
    }

    public static SidedDirection get(EnumFacing side, EnumFacing rot3D, EnumFacing rot2D) {
        if (side == rot3D) {
            return FRONT;
        }
        if (side == EnumFacing.field_82609_l[rot3D.field_82613_h]) {
            return BACK;
        }
        if (rot3D == EnumFacing.DOWN) {
            if (rot2D == side) {
                return TOP;
            }
            if (rot2D == EnumFacing.field_82609_l[side.field_82613_h]) {
                return BOTTOM;
            }
            return SidedDirection.getSide(side, rot2D);
        }
        if (rot3D == EnumFacing.UP) {
            if (rot2D == side) {
                return BOTTOM;
            }
            if (rot2D == EnumFacing.field_82609_l[side.field_82613_h]) {
                return TOP;
            }
            return SidedDirection.getSide(side, rot2D);
        }
        if (side == EnumFacing.DOWN) {
            return BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TOP;
        }
        return SidedDirection.getSide(side, rot3D);
    }

    static {
        VALUES = SidedDirection.values();
        CACHED_SIDES = new SidedDirection[36];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            block1: for (EnumFacing rot : EnumFacing.field_82609_l) {
                for (SidedDirection d : VALUES) {
                    if (d.directions[rot.ordinal()] != side) continue;
                    SidedDirection.CACHED_SIDES[side.ordinal() + rot.ordinal() * 6] = d;
                    continue block1;
                }
            }
        }
    }
}

