/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component.area;

import elan.tweaks.common.gui.component.BackgroundUIComponent;
import elan.tweaks.common.gui.component.UIContext;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.common.gui.layout.hex.HexLayout;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearchProcessPort;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.dto.AspectHex;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.HexHighlightTexture;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.HexTexture;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.UnknownAspectTagTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/AspectHexMapUIComponent;", "Lelan/tweaks/common/gui/component/BackgroundUIComponent;", "centerUiOrigin", "Lelan/tweaks/common/gui/dto/VectorXY;", "research", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "hexLayout", "Lelan/tweaks/common/gui/layout/hex/HexLayout;", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/dto/AspectHex;", "<init>", "(Lelan/tweaks/common/gui/dto/VectorXY;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;Lelan/tweaks/common/gui/layout/hex/HexLayout;)V", "onDrawBackground", "", "uiMousePosition", "partialTicks", "", "context", "Lelan/tweaks/common/gui/component/UIContext;", "drawCorruptedNotes", "drawMouseOverHighlight", "drawHexes", "draw", "hex", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/dto/AspectHex$Occupied$Root;", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/dto/AspectHex$Occupied$Node;", "drawConnections", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/dto/AspectHex$Occupied;", "ThaumcraftResearchTweaks"})
@SourceDebugExtension(value={"SMAP\nAspectHexMapUIComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspectHexMapUIComponent.kt\nelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/AspectHexMapUIComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n2642#2:90\n1557#2:92\n1628#2,3:93\n808#2,11:96\n2642#2:107\n1863#2,2:109\n1863#2,2:111\n1#3:91\n1#3:108\n*S KotlinDebug\n*F\n+ 1 AspectHexMapUIComponent.kt\nelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/AspectHexMapUIComponent\n*L\n50#1:90\n54#1:92\n54#1:93,3\n55#1:96,11\n56#1:107\n57#1:109,2\n84#1:111,2\n50#1:91\n56#1:108\n*E\n"})
public final class AspectHexMapUIComponent
implements BackgroundUIComponent {
    @NotNull
    private final VectorXY centerUiOrigin;
    @NotNull
    private final ResearchProcessPort research;
    @NotNull
    private final HexLayout<AspectHex> hexLayout;

    public AspectHexMapUIComponent(@NotNull VectorXY centerUiOrigin, @NotNull ResearchProcessPort research, @NotNull HexLayout<AspectHex> hexLayout) {
        Intrinsics.checkNotNullParameter((Object)centerUiOrigin, (String)"centerUiOrigin");
        Intrinsics.checkNotNullParameter((Object)research, (String)"research");
        Intrinsics.checkNotNullParameter(hexLayout, (String)"hexLayout");
        this.centerUiOrigin = centerUiOrigin;
        this.research = research;
        this.hexLayout = hexLayout;
    }

    @Override
    public void onDrawBackground(@NotNull VectorXY uiMousePosition, float partialTicks, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.research.missingNotes()) {
            return;
        }
        if (this.research.notesCorrupted()) {
            this.drawCorruptedNotes(context);
            return;
        }
        this.drawMouseOverHighlight(uiMousePosition, context);
        this.drawHexes(context);
    }

    private final void drawCorruptedNotes(UIContext context) {
        String header = StatCollector.func_74838_a((String)"tc.research.notes.corrupted.line.1");
        String body = StatCollector.func_74838_a((String)"tc.research.notes.corrupted.line.2");
        String[] stringArray = new String[]{header, body};
        context.drawTooltipCentered(this.centerUiOrigin, stringArray);
    }

    private final void drawMouseOverHighlight(VectorXY uiMousePosition, UIContext context) {
        if (this.research.notEditable()) {
            return;
        }
        AspectHex aspectHex = (AspectHex)this.hexLayout.get(uiMousePosition);
        if (aspectHex == null) {
            return;
        }
        AspectHex hex = aspectHex;
        if (hex instanceof AspectHex.Occupied.Root) {
            return;
        }
        context.drawBlending(HexHighlightTexture.INSTANCE, hex.getUiOrigin(), HexHighlightTexture.INSTANCE.getColorMask());
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHexes(UIContext context) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Pair pair;
        Iterable $this$onEach$iv = this.hexLayout.asOriginList();
        boolean $i$f$onEach = false;
        Object object = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2418$iv = object;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            pair = (Pair)element$iv;
            boolean bl2 = false;
            VectorXY uiOrigin = (VectorXY)pair.component1();
            AspectHex hex = (AspectHex)pair.component2();
            if (hex instanceof AspectHex.Occupied.Root || !this.research.incomplete()) continue;
            context.drawBlending(HexTexture.INSTANCE, uiOrigin, HexTexture.INSTANCE.getColorMask());
        }
        Iterable $this$map$iv = object;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add((AspectHex)p0.getSecond());
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AspectHex.Occupied)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$onEach$iv = (List)destination$iv$iv;
        $i$f$onEach = false;
        object = $this$onEach$iv;
        $this$onEach_u24lambda_u2418$iv = object;
        bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            AspectHex.Occupied hex = (AspectHex.Occupied)element$iv;
            boolean bl4 = false;
            this.drawConnections(hex, context);
        }
        Iterable $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AspectHex.Occupied hex = (AspectHex.Occupied)element$iv;
            boolean bl5 = false;
            AspectHex.Occupied occupied = hex;
            if (occupied instanceof AspectHex.Occupied.Root) {
                this.draw((AspectHex.Occupied.Root)hex, context);
                continue;
            }
            if (occupied instanceof AspectHex.Occupied.Node) {
                this.draw((AspectHex.Occupied.Node)hex, context);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void draw(AspectHex.Occupied.Root hex, UIContext context) {
        context.drawOrb(hex.getUiCenter());
        if (this.research.shouldObfuscate(hex.getAspect())) {
            context.drawBlending(UnknownAspectTagTexture.INSTANCE, hex.getUiOrigin(), UnknownAspectTagTexture.INSTANCE.getColorMask());
        } else {
            UIContext.DefaultImpls.drawTag$default(context, hex.getAspect(), 0, 0, 0, 0.0f, hex.getUiOrigin(), 30, null);
        }
    }

    private final void draw(AspectHex.Occupied.Node hex, UIContext context) {
        if (this.research.shouldObfuscate(hex.getAspect())) {
            context.drawBlending(UnknownAspectTagTexture.INSTANCE, hex.getUiOrigin(), UnknownAspectTagTexture.INSTANCE.getColorMask());
        } else if (hex.getNotOnRootPath()) {
            UIContext.DefaultImpls.drawTagMonochrome$default(context, hex.getAspect(), 0.0f, hex.getUiOrigin(), 2, null);
        } else {
            UIContext.DefaultImpls.drawTag$default(context, hex.getAspect(), 0, 0, 0, 0.0f, hex.getUiOrigin(), 30, null);
        }
    }

    private final void drawConnections(AspectHex.Occupied hex, UIContext context) {
        Iterable $this$forEach$iv = hex.getConnectionTargetsCenters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VectorXY connectionTargetCenter = (VectorXY)element$iv;
            boolean bl = false;
            context.drawLine(hex.getUiCenter(), connectionTargetCenter);
        }
    }
}

