/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.thaumicexploration.research;

import flaxbeard.thaumicexploration.common.ConfigTX;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class ReplicatorRecipes {
    private static final ArrayList<Item> allowedItemsWildcard = new ArrayList();
    private static final ArrayList<ImmutablePair<Item, Integer>> allowedItems = new ArrayList();
    private static final ArrayList<Item> forbiddenItems = new ArrayList();

    public static boolean canStackBeReplicated(ItemStack stack) {
        int[] oreIDs;
        Item item = stack.func_77973_b();
        if (allowedItemsWildcard.contains(item)) {
            return true;
        }
        if (allowedItems.contains(ImmutablePair.of((Object)item, (Object)stack.func_77960_j()))) {
            return true;
        }
        if (forbiddenItems.contains(item)) {
            return false;
        }
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!ReplicatorRecipes.checkOreDictRules(oreName)) continue;
            AspectList ot = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
            if ((ot = ThaumcraftCraftingManager.getBonusTags((ItemStack)stack, (AspectList)ot)).getAspects().length <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean checkOreDictRules(String oreName) {
        return oreName != null && (oreName.equals("logWood") || oreName.equals("treeLeaves") || oreName.equals("slabWood") || oreName.equals("stairWood") || ConfigTX.allowModStoneReplication && (oreName.equals("stone") || oreName.equals("cobblestone")) || ConfigTX.allowModWoodReplication && oreName.equals("plankWood"));
    }

    static {
        if (!ConfigTX.allowModWoodReplication) {
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150376_bx));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150487_bG));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150476_ad));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150481_bH));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150485_bF));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150364_r));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150363_s));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150344_f));
        }
        if (!ConfigTX.allowModStoneReplication) {
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150348_b));
            allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150347_e));
        }
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150341_Y));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150446_ar));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150354_m));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150322_A));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150372_bz));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150336_V));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150389_bf));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150417_aV));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150390_bg));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150385_bj));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150387_bl));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150425_aM));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150351_n));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150359_w));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150349_c));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150346_d));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150433_aE));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150435_aG));
        allowedItemsWildcard.add(Item.func_150898_a((Block)Blocks.field_150405_ch));
        allowedItemsWildcard.trimToSize();
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150348_b), (Object)0));
        if (!ConfigTX.allowModWoodReplication && ConfigTX.allowMagicPlankReplication) {
            allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)ConfigBlocks.blockWoodenDevice), (Object)6));
            allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)ConfigBlocks.blockWoodenDevice), (Object)7));
        }
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)0));
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)3));
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)1));
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)5));
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)4));
        allowedItems.add((ImmutablePair<Item, Integer>)ImmutablePair.of((Object)Item.func_150898_a((Block)Blocks.field_150333_U), (Object)6));
        allowedItems.trimToSize();
        forbiddenItems.add(Item.func_150898_a((Block)ConfigBlocks.blockMagicalLog));
        forbiddenItems.add(Item.func_150898_a((Block)ConfigBlocks.blockMagicalLeaves));
        if (ConfigTX.allowModWoodReplication && !ConfigTX.allowMagicPlankReplication) {
            forbiddenItems.add(Item.func_150898_a((Block)ConfigBlocks.blockWoodenDevice));
        }
        forbiddenItems.trimToSize();
    }
}

