/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.cache.CraftingGridCache;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelStatic;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.WrapperInvSlot;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class PartP2PInterface
extends PartP2PTunnelStatic<PartP2PInterface>
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IInterfaceHost,
ISidedInventory,
IAEAppEngInventory,
ITileStorageMonitorable,
IPriorityHost {
    boolean needUpdateOnNetworkBooted = false;
    boolean lastPowerStart = false;
    private final DualityInterface duality = new DualityInterface(this.getProxy(), this){

        @Override
        public void updateCraftingList() {
            if (!PartP2PInterface.this.isOutput()) {
                CraftingGridCache.pauseRebuilds();
                super.updateCraftingList();
                try {
                    for (PartP2PInterface p2p : PartP2PInterface.this.getOutputs()) {
                        p2p.duality.updateCraftingList();
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                CraftingGridCache.unpauseRebuilds();
            } else {
                PartP2PInterface p2p = (PartP2PInterface)PartP2PInterface.this.getInput();
                if (p2p != null) {
                    this.craftingList = ((PartP2PInterface)p2p).duality.craftingList;
                    try {
                        this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
            boolean powerState = PartP2PInterface.this.proxy.isActive();
            if (PartP2PInterface.this.needUpdateOnNetworkBooted || PartP2PInterface.this.lastPowerStart != powerState) {
                PartP2PInterface.this.needUpdateOnNetworkBooted = false;
                PartP2PInterface.this.lastPowerStart = powerState;
                PartP2PInterface.this.updateSharingInventory();
            }
            return super.tickingRequest(node, ticksSinceLastCall);
        }

        @Override
        protected boolean hasWorkToDo() {
            if (PartP2PInterface.this.isOutput()) {
                return this.hasItemsToSend() || this.hasConfig() || !this.getStorage().isEmpty();
            }
            return super.hasWorkToDo();
        }

        @Override
        public void readConfig() {
            if (PartP2PInterface.this.isOutput()) {
                PartP2PInterface p2p = (PartP2PInterface)PartP2PInterface.this.getInput();
                boolean alertDevice = false;
                if (p2p != null) {
                    this.setHasConfig(p2p.duality.hasConfig());
                    alertDevice = this.hasWorkToDo();
                } else {
                    this.setHasConfig(false);
                }
                if (alertDevice) {
                    try {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    }
                    catch (GridAccessException gridAccessException) {}
                } else {
                    try {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                this.notifyNeighbors();
            } else {
                super.readConfig();
            }
        }

        @Override
        public void addDrops(List<ItemStack> drops) {
            if (!PartP2PInterface.this.isOutput()) {
                super.addDrops(drops);
                try {
                    for (PartP2PInterface p2p : PartP2PInterface.this.getOutputs()) {
                        p2p.duality.addDrops(drops);
                    }
                }
                catch (GridAccessException gridAccessException) {}
            } else {
                if (this.getWaitingToSend() != null) {
                    for (ItemStack is : this.getWaitingToSend()) {
                        if (is == null) continue;
                        drops.add(is);
                    }
                }
                for (ItemStack is : this.getUpgrades()) {
                    if (is == null) continue;
                    drops.add(is);
                }
                for (ItemStack is : this.getPatterns()) {
                    if (is == null) continue;
                    drops.add(is);
                }
            }
        }

        @Override
        public int getInstalledUpgrades(Upgrades u) {
            if (PartP2PInterface.this.isOutput() && u == Upgrades.PATTERN_CAPACITY) {
                return -1;
            }
            return super.getInstalledUpgrades(u);
        }

        @Override
        public int getConfigSize() {
            if (PartP2PInterface.this.isOutput()) {
                return -1;
            }
            return super.getConfigSize();
        }
    };

    public PartP2PInterface(ItemStack is) {
        super(is);
    }

    private void updateSharingInventory() {
        this.duality.readConfig();
        if (this.isOutput()) {
            PartP2PInterface p2p = (PartP2PInterface)this.getInput();
            if (this.proxy.isActive() && p2p != null) {
                if (!this.duality.sharedInventory && !this.duality.getStorage().isEmpty()) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    AppEngInternalInventory storageAppEng = this.duality.getStorage();
                    AdaptorIInventory p2pInv = new AdaptorIInventory(p2p.duality.getStorage());
                    for (ItemStack itemStack : storageAppEng) {
                        ItemStack drop;
                        if (itemStack == null || (drop = p2pInv.addItems(itemStack)) == null || drop.field_77994_a <= 0) continue;
                        drops.add(drop);
                    }
                    TileEntity te = this.getTileEntity();
                    Platform.spawnDrops(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, drops);
                }
                this.duality.setStorage(p2p.duality.getStorage());
                this.duality.sharedInventory = true;
            } else if (this.duality.sharedInventory) {
                this.duality.setStorage(new AppEngInternalInventory(this, 9));
                this.duality.setSlotInv(new WrapperInvSlot(this.duality.getStorage()));
                this.duality.sharedInventory = false;
            }
        } else {
            if (this.duality.sharedInventory) {
                this.duality.setStorage(new AppEngInternalInventory(this, 9));
                this.duality.setSlotInv(new WrapperInvSlot(this.duality.getStorage()));
                this.duality.sharedInventory = false;
            }
            try {
                for (PartP2PInterface p2p : this.getOutputs()) {
                    p2p.duality.readConfig();
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
        this.updateSharingInventory();
        this.needUpdateOnNetworkBooted = true;
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
        this.updateSharingInventory();
        this.needUpdateOnNetworkBooted = true;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return ((Block)AEApi.instance().definitions().blocks().iface().maybeBlock().get()).func_149733_h(0);
    }

    @Override
    public void gridChanged() {
        this.duality.gridChanged();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.duality.readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.duality.writeToNBT(data);
    }

    @Override
    public NBTTagCompound getMemoryCardData() {
        NBTTagCompound output = super.getMemoryCardData();
        this.duality.getConfigManager().writeToNBT(output);
        return output;
    }

    @Override
    public PartP2PTunnel<?> applyMemoryCard(EntityPlayer player, IMemoryCard memoryCard, ItemStack is) {
        PartP2PTunnel<?> newTunnel = super.applyMemoryCard(player, memoryCard, is);
        NBTTagCompound data = memoryCard.getData(is);
        if (newTunnel instanceof PartP2PInterface) {
            PartP2PInterface p2PInterface = (PartP2PInterface)newTunnel;
            p2PInterface.duality.getConfigManager().readFromNBT(data);
        }
        return newTunnel;
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.duality.initialize();
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        this.duality.addDrops(drops);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 4;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    @Override
    public void onNeighborChanged() {
        this.duality.updateRedstoneState();
    }

    @Override
    public boolean onPartActivate(EntityPlayer p, Vec3 pos) {
        if (super.onPartActivate(p, pos)) {
            return true;
        }
        if (p.func_70093_af()) {
            return false;
        }
        if (Platform.isServer()) {
            Platform.openGUI(p, this.getTileEntity(), this.getSide(), GuiBridge.GUI_INTERFACE);
        }
        return true;
    }

    private void dropPatterns(PartP2PInterface p2p) {
        AppEngInternalInventory patterns = p2p.duality.getPatterns();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < patterns.func_70302_i_(); ++i) {
            if (patterns.func_70301_a(i) == null) continue;
            drops.add(patterns.func_70301_a(i));
        }
        if (!drops.isEmpty()) {
            TileEntity te = p2p.getTileEntity();
            Platform.spawnDrops(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, drops);
        }
    }

    @Override
    protected void copyContents(PartP2PTunnel<?> from) {
        if (from instanceof PartP2PInterface) {
            int i;
            PartP2PInterface fromInterface = (PartP2PInterface)from;
            DualityInterface newDuality = this.duality;
            UpgradeInventory upgrades = (UpgradeInventory)fromInterface.duality.getInventoryByName("upgrades");
            UpgradeInventory newUpgrade = (UpgradeInventory)newDuality.getInventoryByName("upgrades");
            for (int i2 = 0; i2 < upgrades.func_70302_i_(); ++i2) {
                newUpgrade.func_70299_a(i2, upgrades.func_70301_a(i2));
            }
            if (!fromInterface.duality.sharedInventory) {
                AppEngInternalInventory storage = fromInterface.duality.getStorage();
                AppEngInternalInventory newStorage = newDuality.getStorage();
                for (i = 0; i < storage.func_70302_i_(); ++i) {
                    newStorage.func_70299_a(i, storage.func_70301_a(i));
                }
            }
            AppEngInternalInventory patterns = fromInterface.duality.getPatterns();
            boolean drop = true;
            if (!from.isOutput() && !this.isOutput()) {
                for (i = 0; i < patterns.func_70302_i_(); ++i) {
                    newDuality.getPatterns().func_70299_a(i, patterns.func_70301_a(i));
                }
                drop = false;
            }
            if (drop) {
                this.dropPatterns(fromInterface);
            }
        }
    }

    @Override
    protected void copySettings(PartP2PTunnel<?> from) {
        if (from instanceof PartP2PInterface) {
            PartP2PInterface fromInterface = (PartP2PInterface)from;
            DualityInterface newDuality = this.duality;
            IConfigManager config = fromInterface.duality.getConfigManager();
            config.getSettings().forEach(setting -> newDuality.getConfigManager().putSetting((Settings)((Object)setting), config.getSetting((Settings)((Object)setting))));
        }
    }

    @Override
    public IIcon getBreakingTexture() {
        return this.getItemStack().func_77954_c();
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsert(stack);
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.duality.getItemInventory();
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.duality.getFluidInventory();
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    public int func_70302_i_() {
        return this.duality.getStorage().func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.duality.getStorage().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.duality.getStorage().func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.duality.getStorage().func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.duality.getStorage().func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        return this.duality.getStorage().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.duality.getStorage().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.duality.getStorage().func_70297_j_();
    }

    public void func_70296_d() {
        this.duality.getStorage().func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.duality.getStorage().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.duality.getStorage().func_70295_k_();
    }

    public void func_70305_f() {
        this.duality.getStorage().func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.duality.getStorage().func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int s) {
        return this.duality.getAccessibleSlotsFromSide(s);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.duality.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public DualityInterface getInterfaceDuality() {
        return this.duality;
    }

    @Override
    public EnumSet<ForgeDirection> getTargets() {
        return EnumSet.of(this.getSide());
    }

    @Override
    public TileEntity getTileEntity() {
        return super.getHost().getTile();
    }

    @Override
    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this.duality.getMonitorable(side, src, this);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    @Override
    public boolean isBusy() {
        return this.duality.isBusy();
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    @Override
    public int getPriority() {
        return this.duality.getPriority();
    }

    @Override
    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.duality.updateCraftingList();
        this.updateSharingInventory();
    }

    @Override
    public void onTunnelConfigChange() {
        this.updateSharingInventory();
    }

    @Override
    public IInventory getPatterns() {
        if (this.isOutput()) {
            PartP2PInterface input = (PartP2PInterface)this.getInput();
            if (input != null) {
                return input.getPatterns();
            }
            return IInterfaceHost.super.getPatterns();
        }
        return IInterfaceHost.super.getPatterns();
    }

    @Override
    public int rows() {
        if (this.isOutput()) {
            PartP2PInterface input = (PartP2PInterface)this.getInput();
            if (input != null) {
                return input.rows();
            }
            return IInterfaceHost.super.rows();
        }
        return IInterfaceHost.super.rows();
    }

    @Override
    public int rowSize() {
        if (this.isOutput()) {
            PartP2PInterface input = (PartP2PInterface)this.getInput();
            if (input != null) {
                return input.rowSize();
            }
            return IInterfaceHost.super.rowSize();
        }
        return IInterfaceHost.super.rowSize();
    }

    @Override
    public String getName() {
        if (this.isOutput()) {
            PartP2PInterface input = (PartP2PInterface)this.getInput();
            if (input != null) {
                return input.getName();
            }
            return IInterfaceHost.super.getName();
        }
        return IInterfaceHost.super.getName();
    }

    @Override
    public ItemStack getSelfRep() {
        return this.getItemStack();
    }
}

