/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.database.WindowAbstractDatabase;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITextureSheet;
import binnie.core.craftgui.resource.minecraft.StandardTexture;
import binnie.core.genetics.BreedingSystem;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;

class ControlMutationSymbol
extends Control
implements ITooltip {
    private static final Texture MutationPlus = new StandardTexture(2, 94, 16, 16, CraftGUITextureSheet.Controls2);
    private static final Texture MutationArrow = new StandardTexture(20, 94, 32, 16, CraftGUITextureSheet.Controls2);
    private IMutation value = null;
    private boolean discovered;
    private final int type;

    @Override
    public void onRenderBackground() {
        super.onRenderBackground();
        if (this.type == 0) {
            CraftGUI.render.texture(MutationPlus, IPoint.ZERO);
        } else {
            CraftGUI.render.texture(MutationArrow, IPoint.ZERO);
        }
    }

    protected ControlMutationSymbol(IWidget parent, int x, int y, int type) {
        super(parent, x, y, 16 + type * 16, 16.0f);
        this.type = type;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    public void setValue(IMutation value) {
        this.value = value;
        boolean isNEI = ((WindowAbstractDatabase)this.getSuperParent()).isNEI();
        BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
        boolean bl = this.discovered = isNEI || system.isMutationDiscovered(value, ((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        if (this.discovered) {
            this.setColor(0xFFFFFF);
        } else {
            this.setColor(0x777777);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.type != 1 || !this.discovered) {
            return;
        }
        IAlleleSpecies species1 = this.value.getAllele0();
        IAlleleSpecies species2 = this.value.getAllele1();
        BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
        float chance = system.getChance(this.value, ((Window)Window.get(this)).getPlayer(), (IAllele)species1, (IAllele)species2);
        tooltip.add("Current Chance - " + chance + "%");
        if (this.value.getSpecialConditions() != null) {
            for (String string : this.value.getSpecialConditions()) {
                tooltip.add(string);
            }
        }
    }
}

