/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.world.ClientFakePlayer;
import blockrenderer6343.client.world.DummyWorld;
import codechicken.lib.math.MathHelper;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ConstructableUtility;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BRUtil {
    public static final ClientFakePlayer FAKE_PLAYER = new ClientFakePlayer(DummyWorld.INSTANCE, new GameProfile(UUID.randomUUID(), "MultiblockBuilder"));
    public static final AutoPlaceEnvironment AUTO_PLACE_ENVIRONMENT = AutoPlaceEnvironment.fromLegacy((IItemSource)CreativeItemSource.instance, (EntityPlayer)FAKE_PLAYER, a -> {});

    public static void projectMultiblock(ItemStack buildStack, ItemStack multiStack, int blocksBelowController) {
        int blockY;
        int blockZ;
        int blockX;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient baseWorld = Minecraft.func_71410_x().field_71441_e;
        Vec3 lookVec = player.func_70040_Z();
        MovingObjectPosition lookingPos = player.func_70614_a(10.0, 1.0f);
        if (lookingPos == null || lookingPos.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            blockX = MathHelper.floor_double((double)(player.field_70165_t + lookVec.field_72450_a * 2.0));
            blockZ = MathHelper.floor_double((double)(player.field_70161_v + lookVec.field_72449_c * 2.0));
            blockY = baseWorld.func_72874_g(blockX, blockZ) + blocksBelowController;
        } else {
            blockX = lookingPos.field_72311_b;
            blockY = lookingPos.field_72312_c + blocksBelowController + 1;
            blockZ = lookingPos.field_72309_d;
        }
        ItemStack copy = multiStack.func_77946_l();
        if (!baseWorld.func_147437_c(blockX, blockY, blockZ)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_space")));
            return;
        }
        if (!copy.func_77973_b().func_77648_a(copy, (EntityPlayer)player, (World)baseWorld, blockX, blockY, blockZ, 0, (float)blockX, (float)(blockY - 1), (float)blockZ)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_block")));
            return;
        }
        ConstructableUtility.handle((ItemStack)buildStack, (EntityPlayer)player, (World)baseWorld, (int)blockX, (int)blockY, (int)blockZ, (int)0);
        baseWorld.func_147468_f(blockX, blockY, blockZ);
        baseWorld.func_147475_p(blockX, blockY, blockZ);
    }

    public static void neiOverlay(WorldSceneRenderer renderer) {
        if (!BlockRenderer6343.isNEELoaded) {
            return;
        }
        NBTTagCompound recipeInputs = new NBTTagCompound();
        GuiRecipe currentScreen = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)currentScreen.firstGui);
        List<ItemStack> ingredients = BRUtil.getIngredients(renderer);
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack itemStack = ingredients.get(i);
            if (itemStack == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.func_77955_b(itemStackNBT);
            itemStackNBT.func_74768_a("Count", itemStack.field_77994_a);
            recipeInputs.func_74782_a("#" + i, (NBTBase)itemStackNBT);
        }
        NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketNEIPatternRecipe(recipeInputs, new NBTTagCompound()));
    }

    public static void copyToHologram(ItemStack triggerStack) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_70694_bm();
        if (stack == null || !(stack.func_77973_b() instanceof ItemConstructableTrigger)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"blockrenderer6343.no_projector")));
        } else {
            StructureLib.instance().proxy().uploadChannels(triggerStack);
        }
    }

    public static List<ItemStack> getIngredients(WorldSceneRenderer renderer) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        LongIterator longIterator = renderer.renderedBlocks.iterator();
        while (longIterator.hasNext()) {
            int z;
            int y;
            long renderedBlock = (Long)longIterator.next();
            int x = CoordinatePacker.unpackX((long)renderedBlock);
            Block block = renderer.world.func_147439_a(x, y = CoordinatePacker.unpackY((long)renderedBlock), z = CoordinatePacker.unpackZ((long)renderedBlock));
            if (block.equals(Blocks.field_150350_a)) continue;
            int meta = renderer.world.func_72805_g(x, y, z);
            int qty = block.func_149745_a(renderer.world.field_73012_v);
            ArrayList itemStacks = new ArrayList();
            if (qty != 1) {
                itemStacks.add(new ItemStack(block));
            } else {
                itemStacks = block.getDrops((World)renderer.world, x, y, z, meta, 0);
            }
            boolean added = false;
            for (ItemStack ingredient : ingredients) {
                if (!NEIClientUtils.areStacksSameTypeWithNBT((ItemStack)ingredient, (ItemStack)((ItemStack)itemStacks.get(0)))) continue;
                ++ingredient.field_77994_a;
                added = true;
                break;
            }
            if (added) continue;
            ingredients.add((ItemStack)itemStacks.get(0));
        }
        return ingredients;
    }

    public static List<List<ItemStack>> scanCandidates(Object multi, IStructureElement<Object> element, ItemStack buildStack, BlockPos block) {
        if (element == null) {
            return Collections.emptyList();
        }
        IStructureElement.BlocksToPlace blocksToPlace = element.getBlocksToPlace(multi, (World)DummyWorld.INSTANCE, block.x, block.y, block.z, buildStack, AUTO_PLACE_ENVIRONMENT);
        if (blocksToPlace == null) {
            return Collections.emptyList();
        }
        Set<ItemStack> rawCandidates = CreativeItemSource.instance.takeEverythingMatches(blocksToPlace.getPredicate(), false, 0).keySet();
        ArrayList<List<ItemStack>> stackedCandidates = new ArrayList<List<ItemStack>>();
        for (ItemStack rawCandidate : rawCandidates) {
            boolean added = false;
            for (List list : stackedCandidates) {
                List firstCandidateTooltip = ((ItemStack)list.get(0)).func_82840_a((EntityPlayer)FAKE_PLAYER, false);
                List rawCandidateTooltip = rawCandidate.func_82840_a((EntityPlayer)FAKE_PLAYER, false);
                if (firstCandidateTooltip.size() <= 1 || rawCandidateTooltip.size() <= 1 || !((String)firstCandidateTooltip.get(1)).equals(rawCandidateTooltip.get(1))) continue;
                list.add(rawCandidate);
                added = true;
                break;
            }
            if (added) continue;
            ArrayList<ItemStack> newStackedCandidate = new ArrayList<ItemStack>();
            newStackedCandidate.add(rawCandidate);
            stackedCandidates.add(newStackedCandidate);
        }
        return stackedCandidates;
    }

    public static long hashStack(ItemStack stack) {
        return (long)stack.func_77973_b().hashCode() * 31L + (long)stack.func_77960_j() * 31L;
    }

    public static long hashBlock(World world, long pos) {
        int x = CoordinatePacker.unpackX((long)pos);
        int y = CoordinatePacker.unpackY((long)pos);
        int z = CoordinatePacker.unpackZ((long)pos);
        Block block = world.func_147439_a(x, y, z);
        return (long)block.hashCode() * 31L + (long)block.func_149643_k(world, x, y, z) * 31L;
    }

    public static int getDamageValue(World world, Block block, long pos) {
        return block.func_149643_k(world, CoordinatePacker.unpackX((long)pos), CoordinatePacker.unpackY((long)pos), CoordinatePacker.unpackZ((long)pos));
    }

    public static void renderOverlay(LongSet positions, long pos, int color, int alpha) {
        Tessellator t = Tessellator.field_78398_a;
        int posX = CoordinatePacker.unpackX((long)pos);
        int posY = CoordinatePacker.unpackY((long)pos);
        int posZ = CoordinatePacker.unpackZ((long)pos);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
        t.func_78382_b();
        t.func_78384_a(color, alpha);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            long neighborPos = CoordinatePacker.pack((int)(posX + dir.offsetX), (int)(posY + dir.offsetY), (int)(posZ + dir.offsetZ));
            if (positions.contains(neighborPos)) continue;
            BRUtil.renderBlockOverlaySide(t, dir);
        }
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void renderBlockOverlaySide(Tessellator tessellator, ForgeDirection side) {
        switch (side) {
            case DOWN: {
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(1.0, 0.0, 0.0);
                tessellator.func_78377_a(1.0, 0.0, 1.0);
                tessellator.func_78377_a(0.0, 0.0, 1.0);
                break;
            }
            case UP: {
                tessellator.func_78377_a(1.0, 1.0, 0.0);
                tessellator.func_78377_a(0.0, 1.0, 0.0);
                tessellator.func_78377_a(0.0, 1.0, 1.0);
                tessellator.func_78377_a(1.0, 1.0, 1.0);
                break;
            }
            case NORTH: {
                tessellator.func_78377_a(0.0, 1.0, 0.0);
                tessellator.func_78377_a(1.0, 1.0, 0.0);
                tessellator.func_78377_a(1.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                tessellator.func_78377_a(1.0, 1.0, 1.0);
                tessellator.func_78377_a(0.0, 1.0, 1.0);
                tessellator.func_78377_a(0.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 1.0);
                break;
            }
            case WEST: {
                tessellator.func_78377_a(0.0, 1.0, 1.0);
                tessellator.func_78377_a(0.0, 1.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 1.0);
                break;
            }
            case EAST: {
                tessellator.func_78377_a(1.0, 1.0, 0.0);
                tessellator.func_78377_a(1.0, 1.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 0.0);
            }
        }
    }

    public static void drawCenteredScaledString(String text, double textX, double textY, int fontColor, double fontScale) {
        BRUtil.drawScaledString(text, textX, textY, fontColor, true, true, fontScale);
    }

    public static void drawScaledString(String text, double textX, double textY, int fontColor, boolean centered, boolean fontShadow, double fontScale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        if (fontScale != 1.0) {
            textX /= fontScale;
            textY /= fontScale;
            GL11.glScaled((double)fontScale, (double)fontScale, (double)0.0);
        }
        double dTextX = textX - (double)((int)textX);
        double dTextY = textY - (double)((int)textY);
        double textWidth = fontRenderer.func_78256_a(text);
        GL11.glTranslated((double)dTextX, (double)dTextY, (double)0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (fontShadow) {
            fontRenderer.func_78261_a(text, centered ? (int)(textX - textWidth / 2.0) : (int)textX, (int)textY, fontColor);
        } else {
            fontRenderer.func_78276_b(text, centered ? (int)(textX - textWidth / 2.0) : (int)textX, (int)textY, fontColor);
        }
        GL11.glPopMatrix();
    }
}

