/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.common.sort.color.ItemColorHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ClientSortData {
    private final int color;
    private final String name;
    private final IntList slotNumbers = new IntArrayList();

    @SideOnly(value=Side.CLIENT)
    public static ClientSortData of(ItemStack itemStack, boolean getColor, boolean getName) {
        int color;
        int n = color = getColor ? ItemColorHelper.getItemColorHue(itemStack) : 0;
        String name = getName ? (itemStack != null ? itemStack.func_82833_r() : "") : "";
        return new ClientSortData(color, name);
    }

    public static ClientSortData readFromPacket(PacketBuffer buf) throws IOException {
        int color = buf.func_150792_a();
        String name = buf.func_150789_c(64);
        ClientSortData sortData = new ClientSortData(color, name);
        int n = buf.func_150792_a();
        for (int i = 0; i < n; ++i) {
            sortData.getSlotNumbers().add(buf.func_150792_a());
        }
        return sortData;
    }

    public ClientSortData(int color, String name) {
        this.color = color;
        this.name = name;
    }

    public int getColor() {
        return this.color;
    }

    public IntList getSlotNumbers() {
        return this.slotNumbers;
    }

    public String getName() {
        return this.name;
    }

    public void writeToPacket(PacketBuffer buf) throws IOException {
        buf.func_150787_b(this.color);
        buf.func_150785_a(this.name);
        buf.func_150787_b(this.slotNumbers.size());
        IntListIterator intListIterator = this.slotNumbers.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            buf.func_150787_b(i);
        }
    }
}

