/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockCopper;
import ganymedes01.etfuturum.client.sound.ModSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCopperBulb
extends BlockCopper {
    protected final boolean powered;

    public BlockCopperBulb(boolean powered) {
        String[] stringArray;
        if (powered) {
            String[] stringArray2 = new String[16];
            stringArray2[0] = "copper_bulb_powered";
            stringArray2[1] = "exposed_copper_bulb_powered";
            stringArray2[2] = "weathered_copper_bulb_powered";
            stringArray2[3] = "oxidized_copper_bulb_powered";
            stringArray2[4] = "copper_bulb_lit_powered";
            stringArray2[5] = "exposed_copper_bulb_lit_powered";
            stringArray2[6] = "weathered_copper_bulb_lit_powered";
            stringArray2[7] = "oxidized_copper_bulb_lit_powered";
            stringArray2[8] = "waxed_copper_bulb_powered";
            stringArray2[9] = "waxed_exposed_copper_bulb_powered";
            stringArray2[10] = "waxed_weathered_copper_bulb_powered";
            stringArray2[11] = "waxed_oxidized_copper_bulb_powered";
            stringArray2[12] = "waxed_copper_bulb_lit_powered";
            stringArray2[13] = "waxed_exposed_copper_bulb_lit_powered";
            stringArray2[14] = "waxed_weathered_copper_bulb_lit_powered";
            stringArray = stringArray2;
            stringArray2[15] = "waxed_oxidized_copper_bulb_lit";
        } else {
            String[] stringArray3 = new String[16];
            stringArray3[0] = "copper_bulb";
            stringArray3[1] = "exposed_copper_bulb";
            stringArray3[2] = "weathered_copper_bulb";
            stringArray3[3] = "oxidized_copper_bulb";
            stringArray3[4] = "copper_bulb_lit";
            stringArray3[5] = "exposed_copper_bulb_lit";
            stringArray3[6] = "weathered_copper_bulb_lit";
            stringArray3[7] = "oxidized_copper_bulb_lit";
            stringArray3[8] = "waxed_copper_bulb";
            stringArray3[9] = "waxed_exposed_copper_bulb";
            stringArray3[10] = "waxed_weathered_copper_bulb";
            stringArray3[11] = "waxed_oxidized_copper_bulb";
            stringArray3[12] = "waxed_copper_bulb_lit";
            stringArray3[13] = "waxed_exposed_copper_bulb_lit";
            stringArray3[14] = "waxed_weathered_copper_bulb_lit";
            stringArray = stringArray3;
            stringArray3[15] = "waxed_oxidized_copper_bulb_lit";
        }
        super(stringArray);
        this.powered = powered;
        this.setBlockSound(ModSounds.soundCopperBulb);
    }

    @Override
    public String getNameFor(ItemStack stack) {
        String type = this.getTypes()[stack.func_77960_j() % 4 + (stack.func_77960_j() > 7 ? 8 : 0)];
        return "".equals(type) ? this.func_149739_a().replace("tile.", "").replace(this.getNameDomain() + ".", "") : type;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 8));
        list.add(new ItemStack(item, 1, 9));
        list.add(new ItemStack(item, 1, 10));
        list.add(new ItemStack(item, 1, 11));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int n;
        switch (world.func_72805_g(x, y, z) % 8) {
            case 7: {
                n = 4;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 5: {
                n = 12;
                break;
            }
            case 4: {
                n = 15;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public int func_149736_g(World worldIn, int x, int y, int z, int side) {
        int n;
        switch (worldIn.func_72805_g(x, y, z) % 8) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n = 15;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public boolean func_149740_M() {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.field_72995_K) {
            boolean poweredByRedstone = world.func_72864_z(x, y, z);
            if (!this.powered && poweredByRedstone || this.powered && !poweredByRedstone) {
                this.switchBulbState(world, x, y, z);
            }
        }
    }

    private void switchBulbState(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        boolean lit = this.isLit(world, x, y, z, meta);
        if (!this.powered) {
            world.func_72908_a((double)x, (double)y, (double)z, "minecraft_1.21:block.copper_bulb.turn_" + (lit ? "off" : "on"), 1.0f, 1.0f);
            meta = lit ? (meta -= 4) : (meta += 4);
        }
        world.func_147465_d(x, y, z, this.getOppositeState(), meta, 3);
    }

    protected boolean isLit(World world, int x, int y, int z, int meta) {
        return meta % 8 > 3;
    }

    protected Block getOppositeState() {
        return this.powered ? ModBlocks.COPPER_BULB.get() : ModBlocks.POWERED_COPPER_BULB.get();
    }

    @Override
    public int func_149692_a(int meta) {
        return meta % 4 + (meta > 7 ? 8 : 0);
    }

    public int func_149643_k(World worldIn, int x, int y, int z) {
        return this.func_149692_a(worldIn.func_72805_g(x, y, z));
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return ModBlocks.COPPER_BULB.getItem();
    }

    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return ModBlocks.COPPER_BULB.getItem();
    }
}

