/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ganymedes01.etfuturum.client.LayeredColorMaskTexture;
import ganymedes01.etfuturum.client.OpenGLHelper;
import ganymedes01.etfuturum.client.model.ModelBanner;
import ganymedes01.etfuturum.lib.EnumColor;
import ganymedes01.etfuturum.tileentities.TileEntityBanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class TileEntityBannerRenderer
extends TileEntitySpecialRenderer {
    private static final Map<String, TimedBannerTexture> CANVAS_TEXTURES = Maps.newHashMap();
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("textures/entity/banner_base.png");
    private final ModelBanner bannerModel = new ModelBanner();

    private ResourceLocation getTexture(TileEntityBanner banner) {
        String s = banner.getPatternResourceLocation();
        if (s.isEmpty()) {
            return null;
        }
        TimedBannerTexture texture = CANVAS_TEXTURES.get(s);
        if (texture == null) {
            if (CANVAS_TEXTURES.size() >= 256) {
                long i = System.currentTimeMillis();
                Iterator<String> iterator = CANVAS_TEXTURES.keySet().iterator();
                while (iterator.hasNext()) {
                    String s1 = iterator.next();
                    TimedBannerTexture texture1 = CANVAS_TEXTURES.get(s1);
                    if (i - texture1.time <= 60000L) continue;
                    Minecraft.func_71410_x().func_110434_K().func_147645_c(texture1.texture);
                    iterator.remove();
                }
                if (CANVAS_TEXTURES.size() >= 256) {
                    return null;
                }
            }
            List<TileEntityBanner.EnumBannerPattern> list1 = banner.getPatternList();
            List<EnumColor> list = banner.getColorList();
            ArrayList arraylist = Lists.newArrayList();
            Iterator<TileEntityBanner.EnumBannerPattern> patters = list1.iterator();
            while (patters.hasNext()) {
                arraylist.add("textures/entity/banner/" + patters.next().getPatternName() + ".png");
            }
            texture = new TimedBannerTexture();
            texture.texture = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(texture.texture, (ITextureObject)new LayeredColorMaskTexture(BASE_TEXTURE, arraylist, list));
            CANVAS_TEXTURES.put(s, texture);
        }
        texture.time = System.currentTimeMillis();
        return texture.texture;
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileEntityBanner banner = (TileEntityBanner)tile;
        int meta = tile.func_145831_w() != null ? banner.func_145832_p() : 0;
        OpenGLHelper.pushMatrix();
        float f1 = 0.6666667f;
        if (banner.isStanding) {
            OpenGLHelper.translate((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            OpenGLHelper.rotate(-((float)(meta * 360) / 16.0f), 0.0f, 1.0f, 0.0f);
            this.bannerModel.bannerStand.field_78806_j = true;
        } else {
            float f3 = 0.0f;
            if (meta == 2) {
                f3 = 180.0f;
            }
            if (meta == 4) {
                f3 = 90.0f;
            }
            if (meta == 5) {
                f3 = -90.0f;
            }
            OpenGLHelper.translate((float)x + 0.5f, (float)y - 0.25f * f1, (float)z + 0.5f);
            OpenGLHelper.rotate(-f3, 0.0f, 1.0f, 0.0f);
            OpenGLHelper.translate(0.0f, -0.3125f, -0.4375f);
            this.bannerModel.bannerStand.field_78806_j = false;
        }
        long worldTime = banner.func_145831_w() != null ? banner.func_145831_w().func_82737_E() : 0L;
        int animationProgress100 = (banner.field_145851_c % 100 * 7 + banner.field_145848_d % 100 * 9 + banner.field_145849_e % 100 * 13 + (int)(worldTime % 100L)) % 100;
        float f3 = (float)animationProgress100 + partialTicks;
        this.bannerModel.bannerSlate.field_78795_f = (-0.0125f + 0.01f * MathHelper.func_76134_b((float)(f3 * 0.01f * 2.0f * (float)Math.PI))) * (float)Math.PI;
        OpenGLHelper.enableRescaleNormal();
        ResourceLocation resourcelocation = this.getTexture(banner);
        if (resourcelocation != null) {
            this.func_147499_a(resourcelocation);
            OpenGLHelper.pushMatrix();
            OpenGLHelper.scale(f1, -f1, -f1);
            this.bannerModel.renderAll();
            OpenGLHelper.popMatrix();
        }
        OpenGLHelper.colour(1.0f, 1.0f, 1.0f);
        OpenGLHelper.popMatrix();
    }

    static class TimedBannerTexture {
        public long time;
        public ResourceLocation texture;

        TimedBannerTexture() {
        }
    }
}

