/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.cthandlers;

import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.recipes.BlastFurnaceRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.etfuturum.blastFurnace")
public class CTBlastFurnace {
    @ZenMethod
    public static void remove(IItemStack output, IIngredient input) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null");
        }
        Map furnaceSmeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        ItemStackMap smeltingList = new ItemStackMap();
        smeltingList.putAll(furnaceSmeltingList);
        smeltingList.putAll(BlastFurnaceRecipes.smelting().smeltingList);
        smeltingList.entrySet().removeIf(stack -> BlastFurnaceRecipes.smelting().smeltingBlacklist.contains((ItemStack)stack.getKey()));
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        ArrayList<ItemStack> toRemoveValues = new ArrayList<ItemStack>();
        ArrayList<Float> toRemoveExperiences = new ArrayList<Float>();
        for (Map.Entry entry : smeltingList.entrySet()) {
            if (!output.matches((IItemStack)new MCItemStack((ItemStack)entry.getValue())) || input != null && !input.matches((IItemStack)new MCItemStack(entry.getKey()))) continue;
            toRemove.add(entry.getKey());
            toRemoveValues.add((ItemStack)entry.getValue());
            toRemoveExperiences.add(Float.valueOf(BlastFurnaceRecipes.smelting().getSmeltingExperience((ItemStack)entry.getValue())));
        }
        if (toRemove.isEmpty()) {
            MineTweakerAPI.logWarning((String)("No blast furnace recipes for " + output));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(toRemove, toRemoveValues, toRemoveExperiences));
        }
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        CTBlastFurnace.remove(output, null);
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input) {
        CTBlastFurnace.addRecipe(output, input, 0.0);
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, double xp) {
        List items = input.getItems();
        if (items == null) {
            MineTweakerAPI.logError((String)("Cannot turn " + input + " into a blast furnace recipe"));
        }
        ItemStack[] items2 = CompatCraftTweaker.getItemStacks(items);
        ItemStack output2 = CompatCraftTweaker.getItemStack(output);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, items2, output2, xp));
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final List<ItemStack> items;
        private final List<ItemStack> values;
        private final List<Float> exps;

        public RemoveAction(List<ItemStack> items, List<ItemStack> values, List<Float> exps) {
            this.items = items;
            this.values = values;
            this.exps = exps;
        }

        public void apply() {
            for (ItemStack item : this.items) {
                BlastFurnaceRecipes.smelting().removeRecipe(item);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (int i = 0; i < this.items.size(); ++i) {
                BlastFurnaceRecipes.smelting().addRecipe(this.items.get(i), this.values.get(i), this.exps.get(i).floatValue());
            }
        }

        public String describe() {
            return "Removing " + this.items.size() + " blast furnace recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.items.size() + " blast furnace recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final double xp;

        public AddRecipeAction(IIngredient ingredient, ItemStack[] input, ItemStack output, double xp) {
            this.ingredient = ingredient;
            this.input = input;
            this.output = output;
            this.xp = xp;
        }

        public void apply() {
            for (ItemStack inputStack : this.input) {
                BlastFurnaceRecipes.smelting().addRecipe(inputStack, this.output, (float)this.xp);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack inputStack : this.input) {
                BlastFurnaceRecipes.smelting().removeRecipe(inputStack);
            }
        }

        public String describe() {
            return "Adding blast furnace recipe for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing blast furnace recipe for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

