/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.blockfinder;

import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.service.blockfinder.FindBlockRequest;
import com.gtnh.findit.util.WorldUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;

public class BlockFindService {
    public BlockFindService() {
        FindItNetwork.registerMessage(FindBlockRequest.Handler.class, FindBlockRequest.class, Side.SERVER);
        FindItNetwork.registerMessage(BlockFoundResponse.Handler.class, BlockFoundResponse.class, Side.CLIENT);
    }

    public void handleRequest(EntityPlayerMP player, FindBlockRequest request) {
        if (FindIt.getCooldownService().checkSearchCooldown(player)) {
            return;
        }
        ArrayList<ChunkPosition> positions = new ArrayList<ChunkPosition>();
        for (TileEntity tileEntity : WorldUtils.getTileEntitiesAround((Entity)player, FindItConfig.SEARCH_RADIUS)) {
            try {
                int tileMeta;
                Block tileBlock = tileEntity.func_145838_q();
                if (!request.getBlockToFind().equals(tileBlock)) continue;
                if (FindIt.isGregTechLoaded() && tileEntity instanceof IGregTechTileEntity) {
                    IGregTechTileEntity gregTech = (IGregTechTileEntity)tileEntity;
                    tileMeta = gregTech.getMetaTileID();
                } else {
                    tileMeta = tileEntity.func_145832_p();
                }
                if (request.getMetaToFind() != tileMeta) continue;
                positions.add(new ChunkPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
                if (positions.size() != FindItConfig.MAX_RESPONSE_SIZE) continue;
                break;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        FindItNetwork.CHANNEL.sendTo((IMessage)new BlockFoundResponse(positions), player);
    }
}

