/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.common.research.SimpleResearchItem;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.research.ResearchManager;

public class InfusionDisguiseArmor
extends InfusionRunicAugmentRecipe {
    public static final ItemStack[] COMPONENTS = new ItemStack[]{new ItemStack(Items.field_151123_aH), new ItemStack(ConfigItems.itemResource, 1, 3), new ItemStack(Items.field_151123_aH), new ItemStack(ConfigItems.itemResource, 1, 3)};
    public static final AspectList ASPECTS = new AspectList().add(Aspect.SLIME, 12).add(Aspect.ARMOR, 10).add(Aspect.MAGIC, 8);
    private Map<ItemStack, List<ItemStack>> cachedItems = new HashMap<ItemStack, List<ItemStack>>();

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (input.size() != COMPONENTS.length + 1 || !ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)SimpleResearchItem.getFullName("ARMORDISGUISE"))) {
            return false;
        }
        List copy = (List)input.clone();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(copy.size());
        for (ItemStack required : COMPONENTS) {
            boolean contains = false;
            for (int i = 0; i < copy.size(); ++i) {
                if (!InfusionRecipe.areItemStacksEqual((ItemStack)required, (ItemStack)((ItemStack)copy.get(i)), (boolean)true)) continue;
                contains = true;
                result.add((ItemStack)copy.get(i));
                copy.remove(i);
                break;
            }
            if (contains) continue;
            return false;
        }
        ItemStack disguise = (ItemStack)copy.get(0);
        if (!this.isValidDisguise(central, disguise)) {
            return false;
        }
        result.add(0, disguise);
        this.cachedItems.put(central, result);
        return true;
    }

    public ItemStack[] getComponents(ItemStack input) {
        List<ItemStack> components = this.cachedItems.get(input);
        if (components != null) {
            return components.toArray(new ItemStack[components.size()]);
        }
        return new ItemStack[0];
    }

    public AspectList getAspects(ItemStack input) {
        this.cachedItems.remove(input);
        return ASPECTS;
    }

    public int getInstability(ItemStack input) {
        return -20;
    }

    public Object getRecipeOutput(ItemStack input) {
        List<ItemStack> components = this.cachedItems.get(input);
        if (components != null) {
            return InfusionDisguiseArmor.disguiseStack(input, components.get(0));
        }
        return input;
    }

    public static ItemStack disguiseStack(ItemStack stack, ItemStack disguise) {
        ItemStack out = stack.func_77946_l();
        NBTTagCompound compound = NBTHelper.getPersistentData(out);
        if (disguise.func_77973_b() == Items.field_151068_bn) {
            compound.func_74757_a("disguise", true);
        } else {
            compound.func_74782_a("disguise", (NBTBase)disguise.func_77955_b(new NBTTagCompound()));
        }
        return out;
    }

    private boolean isValidDisguise(ItemStack armor, ItemStack disguise) {
        if (this.isDisguised(armor) || this.isDisguised(disguise)) {
            return false;
        }
        int armorPos = EntityLiving.func_82159_b((ItemStack)armor);
        return armorPos != 0 && (this.isInvisItem(disguise) || EntityLiving.func_82159_b((ItemStack)disguise) == armorPos);
    }

    private boolean isDisguised(ItemStack stack) {
        return NBTHelper.hasPersistentData(stack) && NBTHelper.getPersistentData(stack).func_74764_b("disguise");
    }

    private boolean isInvisItem(ItemStack disguise) {
        if (disguise.func_77973_b() == Items.field_151068_bn) {
            List effects = Items.field_151068_bn.func_77832_l(disguise);
            for (Object obj : effects) {
                if (!(obj instanceof PotionEffect) || ((PotionEffect)obj).func_76456_a() != Potion.field_76441_p.func_76396_c()) continue;
                return true;
            }
        }
        return false;
    }
}

