/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.util;

import com.gtnewhorizons.gravisuiteneo.common.Achievements;
import com.gtnewhorizons.gravisuiteneo.common.PacketQuantumShield;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import cpw.mods.fml.common.registry.GameRegistry;
import gravisuite.GraviSuite;
import gravisuite.ItemGraviChestPlate;
import gravisuite.ItemSimpleItems;
import gravisuite.ServerProxy;
import ic2.api.item.ElectricItem;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.Pair;

public class QuantumShieldHelper {
    private static final Map<UUID, Pair<Float, Long>> PLAYER_HEALTH_MAP = new HashMap<UUID, Pair<Float, Long>>();
    private static final int DISCHARGE_CURATIVE = 4000;
    private static final int DISCHARGE_MEDKIT = 4000;
    public static final int DISCHARGE_EXTINGUISH = 1000;
    public static final int DISCHARGE_IDLE = 5000;

    public static boolean hasValidShieldEquipment(EntityPlayer player) {
        ItemStack helmet = player.func_71124_b(4);
        ItemStack chest = player.func_71124_b(3);
        ItemStack leggings = player.func_71124_b(2);
        ItemStack boots = player.func_71124_b(1);
        return chest != null && chest.func_77973_b() instanceof ItemGraviChestPlate && helmet != null && QuantumShieldHelper.checkHelmetItem(helmet.func_77973_b()) && leggings != null && QuantumShieldHelper.checkLegItem(leggings.func_77973_b()) && boots != null && QuantumShieldHelper.checkBootsItem(boots.func_77973_b());
    }

    private static boolean checkHelmetItem(Item item) {
        return item instanceof ItemArmorQuantumSuit || Properties.AdvTweaks.getAllowedShieldHelmets().contains(GameRegistry.findUniqueIdentifierFor((Item)item));
    }

    private static boolean checkLegItem(Item item) {
        return item instanceof ItemArmorQuantumSuit || Properties.AdvTweaks.getAllowedShieldLeggins().contains(GameRegistry.findUniqueIdentifierFor((Item)item));
    }

    private static boolean checkBootsItem(Item item) {
        return item instanceof ItemArmorQuantumSuit || Properties.AdvTweaks.getAllowedShieldBoots().contains(GameRegistry.findUniqueIdentifierFor((Item)item));
    }

    public static void switchShieldMode(EntityPlayer player, ItemStack itemstack) {
        if (!QuantumShieldHelper.hasValidShieldEquipment(player)) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.invalidshieldSetup")));
            return;
        }
        if (!ElectricItem.manager.canUse(itemstack, 50000.0)) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.ShieldUpNotEnoughPower")));
            return;
        }
        if (QuantumShieldHelper.readShieldMode(itemstack)) {
            QuantumShieldHelper.saveShieldMode(itemstack, false);
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"message.graviChestPlate.shieldMode") + " " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.disabled")));
            QuantumShieldHelper.notifyWorldShieldDown(player);
        } else {
            QuantumShieldHelper.saveShieldMode(itemstack, true);
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"message.graviChestPlate.shieldMode") + " " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.text.enabled")));
            QuantumShieldHelper.notifyWorldShieldUp(player);
            player.func_71029_a((StatBase)Achievements.QSHIELD);
        }
    }

    private static void notifyWorldShieldUp(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:qshieldon", 1.25f, 1.0f);
        PacketQuantumShield.issue(player.func_145782_y(), -4);
    }

    public static void notifyWorldShieldDown(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:qshieldoff", 1.25f, 1.0f);
        PacketQuantumShield.issue(player.func_145782_y(), -5);
    }

    public static void runHealthMonitor(EntityPlayer player, ItemStack itemStack) {
        float currHealth = player.func_110143_aJ();
        Pair lastHealthElement = null;
        UUID playerID = player.func_110124_au();
        if (PLAYER_HEALTH_MAP.containsKey(playerID)) {
            lastHealthElement = PLAYER_HEALTH_MAP.get(playerID);
        }
        if (lastHealthElement == null || (Long)lastHealthElement.getRight() - System.currentTimeMillis() < -5000L) {
            lastHealthElement = Pair.of((Object)Float.valueOf(0.0f), (Object)System.currentTimeMillis());
        }
        if (currHealth > ((Float)lastHealthElement.getLeft()).floatValue()) {
            PLAYER_HEALTH_MAP.put(playerID, (Pair<Float, Long>)Pair.of((Object)Float.valueOf(currHealth), (Object)System.currentTimeMillis()));
        } else if (currHealth + 2.0f < ((Float)lastHealthElement.getLeft()).floatValue()) {
            player.func_70606_j(((Float)lastHealthElement.getLeft()).floatValue());
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 40, 4));
            ElectricItem.manager.discharge(itemStack, 4000.0, 4, false, false, false);
            player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:qshieldimpact", 1.25f, 1.0f);
            PacketQuantumShield.issue(player.func_145782_y(), -1);
            if ((Long)lastHealthElement.getRight() - System.currentTimeMillis() < -2000L) {
                PLAYER_HEALTH_MAP.put(playerID, (Pair<Float, Long>)Pair.of((Object)Float.valueOf(currHealth), (Object)System.currentTimeMillis()));
            }
        }
    }

    public static void performMedkitAction(EntityPlayer player, ItemStack itemstack) {
        if (player == null || itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof ItemGraviChestPlate)) {
            return;
        }
        if (ElectricItem.manager.canUse(itemstack, 4000.0)) {
            boolean nanobotsUsed = false;
            for (int i = 0; i < 36; ++i) {
                ItemStack is = player.field_71071_by.field_70462_a[i];
                if (is == null || !(is.func_77973_b() instanceof ItemSimpleItems) || is.func_77960_j() != 7) continue;
                if (is.field_77994_a == 1) {
                    player.field_71071_by.field_70462_a[i] = null;
                } else {
                    --is.field_77994_a;
                }
                nanobotsUsed = true;
                break;
            }
            if (nanobotsUsed) {
                ElectricItem.manager.discharge(itemstack, 4000.0, 4, true, false, false);
                QuantumShieldHelper.curePotions(itemstack, player, true);
                ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.graviChestPlate.MedkitInjected")));
            } else {
                ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.MedkitNoNanoBots")));
            }
        } else {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.MedkitNoPower")));
        }
    }

    public static void curePotions(ItemStack itemstack, EntityPlayer player, boolean medkitCure) {
        ArrayList<Potion> potions = new ArrayList<Potion>();
        potions.add(Potion.field_82731_v);
        if (medkitCure) {
            potions.add(Potion.field_76440_q);
            potions.add(Potion.field_76431_k);
            potions.add(Potion.field_76419_f);
            potions.add(Potion.field_76433_i);
            potions.add(Potion.field_76438_s);
            potions.add(Potion.field_76421_d);
            potions.add(Potion.field_76436_u);
            potions.add(Potion.field_76437_t);
        }
        for (Potion potion : potions) {
            if (!player.func_70644_a(potion) || !ElectricItem.manager.canUse(itemstack, 4000.0)) continue;
            player.func_82170_o(potion.field_76415_H);
            if (medkitCure) continue;
            ElectricItem.manager.discharge(itemstack, 4000.0, 4, true, false, false);
        }
        if (medkitCure) {
            Iterator iterator = player.func_70651_bq().iterator();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            while (iterator.hasNext()) {
                PotionEffect potioneffect = (PotionEffect)iterator.next();
                if (!Potion.field_76425_a[potioneffect.func_76456_a()].func_76398_f()) continue;
                toRemove.add(potioneffect.func_76456_a());
            }
            Iterator iterator2 = toRemove.iterator();
            while (iterator2.hasNext()) {
                int id = (Integer)iterator2.next();
                if (!ElectricItem.manager.canUse(itemstack, 4000.0)) continue;
                player.func_82170_o(id);
            }
        }
    }

    public static boolean readShieldMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData((ItemStack)itemstack);
        return nbttagcompound.func_74767_n("isShieldActive");
    }

    public static void saveShieldMode(ItemStack itemstack, boolean workMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData((ItemStack)itemstack);
        nbttagcompound.func_74757_a("isShieldActive", workMode);
    }
}

