/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.tiered;

import gregtech.api.enums.MetaTileEntityIDs;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicHull;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEDiode
extends MTEBasicHull {
    private long maxAmps;
    private long aAmps;

    public MTEDiode(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, StatCollector.func_74838_a((String)"tooltip.tile.diode.0.name"), new ITexture[0]);
        this.aAmps = this.maxAmps = this.getAmpsfromMeta(aID);
    }

    public MTEDiode(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (this.maxAmps == 0L && !this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            this.aAmps = this.maxAmps = this.getAmpsfromMeta(this.getBaseMetaTileEntity().getMetaTileID());
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (!aPlayer.func_70093_af()) {
            --this.aAmps;
            if (this.aAmps < 0L) {
                this.aAmps = this.maxAmps;
            }
        } else {
            ++this.aAmps;
            if (this.aAmps > this.maxAmps) {
                this.aAmps = 0L;
            }
        }
        GTUtility.sendChatToPlayer(aPlayer, "Max Amps: " + this.aAmps);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("maxAmp", this.maxAmps);
        aNBT.func_74772_a("Amps", this.aAmps);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.maxAmps = aNBT.func_74763_f("maxAmp");
        this.aAmps = aNBT.func_74763_f("Amps");
        super.loadNBTData(aNBT);
    }

    @Override
    public long maxAmperesOut() {
        return this.aAmps;
    }

    @Override
    public long maxAmperesIn() {
        return this.aAmps;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDiode(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    private long getAmpsfromMeta(int meta) {
        if (meta >= MetaTileEntityIDs.Diode2A_ULV.ID && meta <= MetaTileEntityIDs.Diode2A_MAX.ID) {
            return 2L;
        }
        if (meta >= MetaTileEntityIDs.Diode4A_ULV.ID && meta <= MetaTileEntityIDs.Diode4A_MAX.ID) {
            return 4L;
        }
        if (meta >= MetaTileEntityIDs.Diode8A_ULV.ID && meta <= MetaTileEntityIDs.Diode8A_MAX.ID) {
            return 8L;
        }
        if (meta >= MetaTileEntityIDs.Diode12A_ULV.ID && meta <= MetaTileEntityIDs.Diode12A_MAX.ID) {
            return 12L;
        }
        if (meta >= MetaTileEntityIDs.Diode16A_ULV.ID && meta <= MetaTileEntityIDs.Diode16A_MAX.ID) {
            return 16L;
        }
        return 0L;
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[0]);
    }
}

