/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.galacticraft.atmosphere;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bwcrossmod.BartWorksCrossmod;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import org.apache.commons.lang3.tuple.Pair;

public final class BWAtmosphereManager {
    private static final int[][] COEFFICIENT_ARRAY = new int[9][];
    public static final BWAtmosphereManager INSTANCE = new BWAtmosphereManager();
    private static final ArrayListMultimap<Integer, Pair<ISubTagContainer, Integer>> gasConcentration = ArrayListMultimap.create();

    private BWAtmosphereManager() {
        BWAtmosphereManager.COEFFICIENT_ARRAY[0] = new int[]{100};
        BWAtmosphereManager.COEFFICIENT_ARRAY[1] = new int[]{70, 30};
        BWAtmosphereManager.COEFFICIENT_ARRAY[2] = new int[]{60, 25, 15};
        BWAtmosphereManager.COEFFICIENT_ARRAY[3] = new int[]{50, 25, 15, 10};
        BWAtmosphereManager.COEFFICIENT_ARRAY[4] = new int[]{45, 25, 15, 10, 5};
        BWAtmosphereManager.COEFFICIENT_ARRAY[5] = new int[]{45, 20, 15, 10, 5, 5};
        BWAtmosphereManager.COEFFICIENT_ARRAY[6] = new int[]{40, 20, 15, 10, 5, 5, 5};
        BWAtmosphereManager.COEFFICIENT_ARRAY[7] = new int[]{35, 20, 15, 10, 5, 5, 5, 5};
        BWAtmosphereManager.COEFFICIENT_ARRAY[8] = new int[]{35, 15, 15, 10, 5, 5, 5, 5, 5};
    }

    public static List<Pair<ISubTagContainer, Integer>> getGasFromWorldID(int worldID) {
        return gasConcentration.get((Object)worldID);
    }

    public static void removeGasFromWorld(int worldID, ISubTagContainer gas) {
        for (Pair pair : gasConcentration.get((Object)worldID)) {
            if (!((ISubTagContainer)pair.getKey()).equals(gas)) continue;
            gasConcentration.get((Object)worldID).remove(pair);
            return;
        }
    }

    public static void addGasToWorld(int worldID, ISubTagContainer gas, int amount) {
        Pair toadd = Pair.of((Object)gas, (Object)amount);
        gasConcentration.put((Object)worldID, (Object)toadd);
    }

    public static void addGasToWorld(int worldID, Pair<ISubTagContainer, Integer> toPut) {
        gasConcentration.put((Object)worldID, toPut);
    }

    @SafeVarargs
    public static void addGasToWorld(int worldID, Pair<ISubTagContainer, Integer> ... toPut) {
        Arrays.stream(toPut).forEach(toadd -> gasConcentration.put((Object)worldID, toadd));
    }

    private static boolean addGCGasToWorld(int worldID, IAtmosphericGas gas, int aNumber, int aMaxNumber) {
        if (IAtmosphericGas.CO2.equals((Object)gas)) {
            BWAtmosphereManager.addGasToWorld(worldID, Materials.CarbonDioxide, COEFFICIENT_ARRAY[aMaxNumber - 1][aNumber]);
            return true;
        }
        String name = gas.toString();
        ISubTagContainer mat = Materials.get(name = name.charAt(0) + name.substring(1).toLowerCase(Locale.US));
        if (mat == Materials._NULL) {
            mat = WerkstoffLoader.getWerkstoff(name);
        }
        if (mat == Werkstoff.default_null_Werkstoff) {
            return false;
        }
        BWAtmosphereManager.addGasToWorld(worldID, mat, COEFFICIENT_ARRAY[aMaxNumber - 1][aNumber]);
        return true;
    }

    @SubscribeEvent
    public void gcAutoRegister(GalaxyRegistry.PlanetRegisterEvent event) {
        CelestialBody planet = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(event.planetName);
        for (int i = 0; i < planet.atmosphere.size(); ++i) {
            if (BWAtmosphereManager.addGCGasToWorld(planet.getDimensionID(), (IAtmosphericGas)planet.atmosphere.get(i), i, planet.atmosphere.size())) continue;
            BartWorksCrossmod.LOGGER.warn("Unidentified Fluid (" + planet.atmosphere.get(i) + ") in the Atmosphere of: " + planet.getLocalizedName());
        }
    }
}

