/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IBindPlayerInventoryUI;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class CommonBaseMetaTileEntity
extends CoverableTileEntity
implements IGregTechTileEntity {
    protected boolean mNeedsBlockUpdate = true;
    protected boolean mNeedsUpdate = true;
    protected boolean mNeedsTileUpdate = false;
    protected boolean mSendClientData = false;
    protected boolean mInventoryChanged = false;
    protected NBTTagCompound pendingDescriptionPacket;
    private final int[] mTimeStatistics = new int[GregTechAPI.TICKS_FOR_LAG_AVERAGING];
    private boolean hasTimeStatisticsStarted;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;

    protected boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTechAPI.METATILEENTITIES.length && GregTechAPI.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.getMetaTileEntity().setBaseMetaTileEntity(null);
            }
            GregTechAPI.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            if (this.pendingDescriptionPacket != null) {
                this.getMetaTileEntity().onDescriptionPacket(this.pendingDescriptionPacket);
                this.pendingDescriptionPacket = null;
            }
            return true;
        }
        GTLog.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    protected abstract void updateEntityProfiled();

    @Override
    public final void func_145845_h() {
        super.func_145845_h();
        long tTime = this.hasTimeStatisticsStarted ? System.nanoTime() : 0L;
        try {
            this.updateEntityProfiled();
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(GTLog.err);
            try {
                this.onTickFail();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                ex.printStackTrace(GTLog.err);
            }
        }
        if (this.isServerSide() && this.hasTimeStatisticsStarted && this.hasValidMetaTileEntity()) {
            tTime = System.nanoTime() - tTime;
            this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
            this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            if (tTime > 0L && tTime > (long)GregTechAPI.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING * 1000000L && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick() && this.mLagWarningCount++ < 10) {
                GTMod.GT_FML_LOGGER.warn("WARNING: Possible Lag Source at [" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "] in Dimension " + this.field_145850_b.field_73011_w.field_76574_g + " with " + tTime + " ns caused by an instance of " + this.getMetaTileEntity().getClass());
            }
        }
    }

    protected abstract void onTickFail();

    protected void saveMetaTileNBT(NBTTagCompound aNBT) {
        try {
            if (this.hasValidMetaTileEntity()) {
                aNBT.func_74768_a("nbtVersion", GTMod.NBT_VERSION);
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.getMetaTileEntity().getRealInventory().length; ++i) {
                    ItemStack tStack = this.getMetaTileEntity().getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.func_74768_a("IntSlot", i);
                    tStack.func_77955_b(tTag);
                    tItemList.func_74742_a((NBTBase)tTag);
                }
                aNBT.func_74782_a("Inventory", (NBTBase)tItemList);
                try {
                    this.getMetaTileEntity().saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
                    GTMod.logStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.");
            GTMod.logStackTrace(e);
        }
    }

    protected void loadMetaTileNBT(NBTTagCompound aNBT) {
        int nbtVersion = aNBT.func_74762_e("nbtVersion");
        if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
            NBTTagList tItemList = aNBT.func_150295_c("Inventory", 10);
            for (int i = 0; i < tItemList.func_74745_c(); ++i) {
                NBTTagCompound tTag = tItemList.func_150305_b(i);
                int tSlot = this.migrateInventoryIndex(tTag.func_74762_e("IntSlot"), nbtVersion);
                if (tSlot < 0 || tSlot >= this.getMetaTileEntity().getRealInventory().length) continue;
                ItemStack loadedStack = GTUtility.loadItem(tTag);
                if (loadedStack != null && loadedStack.func_77973_b() == ItemList.Display_Fluid.getItem()) {
                    loadedStack = null;
                }
                this.getMetaTileEntity().getRealInventory()[tSlot] = loadedStack;
            }
            try {
                this.getMetaTileEntity().loadNBTData(aNBT);
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("Encountered Exception while loading MetaTileEntity.");
                GTMod.logStackTrace(e);
            }
        }
    }

    protected void sendSoundToPlayers(SoundResource sound, float soundStrength, int soundModulation) {
        GTUtility.sendSoundToPlayers(this.field_145850_b, sound, soundStrength, (float)soundModulation, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected int migrateInventoryIndex(int slotIndex, int nbtVersion) {
        return slotIndex;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    @Override
    public void startTimeStatistics() {
        this.hasTimeStatisticsStarted = true;
    }

    protected void addProfilingInformation(List<String> tList) {
        if (this.hasTimeStatisticsStarted) {
            double tAverageTime = 0.0;
            double tWorstTime = 0.0;
            int amountOfZero = 0;
            for (int tTime : this.mTimeStatistics) {
                tAverageTime += (double)tTime;
                if ((double)tTime > tWorstTime) {
                    tWorstTime = tTime;
                }
                if (tTime != 0) continue;
                ++amountOfZero;
            }
            int samples = this.mTimeStatistics.length - amountOfZero;
            if (samples > 0) {
                tList.add("Average CPU load of ~" + GTUtility.formatNumbers(tAverageTime / (double)samples) + "ns over " + GTUtility.formatNumbers(samples) + " ticks with worst time of " + GTUtility.formatNumbers(tWorstTime) + "ns.");
            }
        } else {
            this.startTimeStatistics();
            tList.add("Just started tick time statistics.");
        }
        if (this.mLagWarningCount > 0) {
            tList.add("Caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Integer.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTechAPI.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
        }
    }

    @Override
    public int[] getTimeStatistics() {
        return this.mTimeStatistics;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isValidSlot(aIndex);
        }
        return false;
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        IMetaTileEntity imte = this.getMetaTileEntity();
        if (imte == null) {
            return null;
        }
        NBTTagCompound data = imte.getDescriptionData();
        if (data == null) {
            return null;
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        IMetaTileEntity imte = this.getMetaTileEntity();
        if (imte == null) {
            this.pendingDescriptionPacket = pkt.func_148857_g();
            return;
        }
        imte.onDescriptionPacket(pkt.func_148857_g());
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public void issueTileUpdate() {
        this.mNeedsTileUpdate = true;
    }

    @Override
    public boolean isValidFacing(ForgeDirection side) {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().isFacingValid(side);
        }
        return false;
    }

    @Override
    public boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    protected abstract boolean hasValidMetaTileEntity();

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getDescription();
        }
        return GTValues.emptyStringArray;
    }

    @Override
    public boolean isStillValid() {
        return this.hasValidMetaTileEntity();
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return this.hasValidMetaTileEntity() && this.getMetaTileEntity().allowCoverOnSide(side, coverItem);
    }

    @Override
    public void issueCoverUpdate(ForgeDirection side) {
        super.issueCoverUpdate(side);
        this.issueClientUpdate();
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        return meta != null && meta.shouldJoinIc2Enet();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IAddUIWidgets) {
            ((IAddUIWidgets)((Object)this.getMetaTileEntity())).addUIWidgets(builder, buildContext);
            return;
        }
        super.addUIWidgets(builder, buildContext);
    }

    @Override
    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IBindPlayerInventoryUI) {
            ((IBindPlayerInventoryUI)((Object)this.getMetaTileEntity())).bindPlayerInventoryUI(builder, buildContext);
            return;
        }
        super.bindPlayerInventoryUI(builder, buildContext);
    }

    @Override
    public IConfigurationCircuitSupport getConfigurationCircuitSupport() {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IConfigurationCircuitSupport) {
            return (IConfigurationCircuitSupport)((Object)this.getMetaTileEntity());
        }
        return null;
    }

    @Override
    public IItemHandlerModifiable getInventoryHandler() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getInventoryHandler();
        }
        return null;
    }

    @Override
    public boolean useModularUI() {
        return this.hasValidMetaTileEntity();
    }

    @Override
    public String getLocalName() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getLocalName();
        }
        return super.getLocalName();
    }

    @Override
    protected int getGUIWidth() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIWidth();
        }
        return super.getGUIWidth();
    }

    @Override
    protected int getGUIHeight() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIHeight();
        }
        return super.getGUIHeight();
    }

    @Override
    protected boolean doesBindPlayerInventory() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().doesBindPlayerInventory();
        }
        return super.doesBindPlayerInventory();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IAddGregtechLogo) {
            ((IAddGregtechLogo)((Object)this.getMetaTileEntity())).addGregTechLogo(builder);
            return;
        }
        super.addGregTechLogo(builder);
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getStackForm(aAmount);
        }
        return super.getStackForm(aAmount);
    }

    @Override
    public int getTitleColor() {
        if (this.hasValidMetaTileEntity() && this.getMetaTileEntity() instanceof IGetTitleColor) {
            return ((IGetTitleColor)((Object)this.getMetaTileEntity())).getTitleColor();
        }
        return super.getTitleColor();
    }

    @Override
    public int getGUIColorization() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUIColorization();
        }
        return super.getGUIColorization();
    }

    @Override
    protected int getTextColorOrDefault(String textType, int defaultColor) {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getTextColorOrDefault(textType, defaultColor);
        }
        return defaultColor;
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        if (this.hasValidMetaTileEntity()) {
            return this.getMetaTileEntity().getGUITextureSet();
        }
        return super.getGUITextureSet();
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        if (!this.useModularUI()) {
            return null;
        }
        buildContext.setValidator(this.getValidator());
        ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
        builder.setBackground(new IDrawable[]{this.getGUITextureSet().getMainBackground()});
        builder.setGuiTint(this.getGUIColorization());
        if (this.doesBindPlayerInventory()) {
            this.bindPlayerInventoryUI(builder, buildContext);
        }
        this.addUIWidgets(builder, buildContext);
        this.addTitleToUI(builder);
        this.addCoverTabs(builder, buildContext);
        IConfigurationCircuitSupport csc = this.getConfigurationCircuitSupport();
        if (csc != null && csc.allowSelectCircuit()) {
            this.addConfigurationCircuitSlot(builder);
        } else {
            this.addGregTechLogo(builder);
        }
        return builder.build();
    }
}

