/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.crafting.ICraftingIconProvider;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AECableType;
import appeng.core.localization.WailaText;
import appeng.me.helpers.AENetworkProxy;
import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import com.cleanroommc.modularui.utils.item.ItemStackHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ICleanroomReceiver;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTTooltipDataCache;
import gregtech.api.util.GTUtility;
import gregtech.common.capability.CleanroomReference;
import gregtech.mixin.interfaces.accessors.EntityPlayerMPAccessor;
import java.util.List;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;

public abstract class MetaTileEntity
extends CommonMetaTileEntity
implements ICraftingIconProvider {
    public final ItemStackHandler inventoryHandler;
    protected GUIColorOverride colorOverride;
    protected GTTooltipDataCache mTooltipCache = new GTTooltipDataCache();
    private static final String[] FACING_DIRECTION_NAMES = new String[]{"GT5U.waila.facing.down", "GT5U.waila.facing.up", "GT5U.waila.facing.north", "GT5U.waila.facing.south", "GT5U.waila.facing.west", "GT5U.waila.facing.east", "GT5U.waila.facing.unknown"};
    protected final ICleanroomReceiver cleanroomReference = new CleanroomReference();
    private IGregTechTileEntity mBaseMetaTileEntity;
    private String playerLang;
    protected Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x404040);
    protected Supplier<Integer> COLOR_TITLE_WHITE = () -> this.getTextColorOrDefault("title_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_WHITE = () -> this.getTextColorOrDefault("text_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x404040);
    protected Supplier<Integer> COLOR_TEXT_RED = () -> this.getTextColorOrDefault("text_red", 0xFF0000);

    @Override
    public IItemHandlerModifiable getInventoryHandler() {
        return this.inventoryHandler;
    }

    public MetaTileEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        super(aID, aBasicName, aRegionalName, aInvSlotCount);
        this.setBaseMetaTileEntity(GregTechAPI.constructBaseMetaTileEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        this.inventoryHandler = new ItemStackHandler(this.mInventory){

            protected void onContentsChanged(int slot) {
                MetaTileEntity.this.onContentsChanged(slot);
            }
        };
    }

    public MetaTileEntity(String aName, int aInvSlotCount) {
        super(aName, aInvSlotCount);
        this.inventoryHandler = new ItemStackHandler(this.mInventory){

            protected void onContentsChanged(int slot) {
                MetaTileEntity.this.onContentsChanged(slot);
            }
        };
        this.colorOverride = GUIColorOverride.get(this.getGUITextureSet().getMainBackground().location);
    }

    @Override
    @Nullable
    public final IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    public boolean isValid() {
        return this.getBaseMetaTileEntity() != null && this.getBaseMetaTileEntity().getMetaTileEntity() == this && !this.getBaseMetaTileEntity().isDead();
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Class<T> capability, @NotNull ForgeDirection side) {
        if (capability == ICleanroomReceiver.class) {
            return capability.cast(this.cleanroomReference);
        }
        if (capability == ICraftingIconProvider.class) {
            return capability.cast(this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTechAPI.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    @Override
    public String getLocalName() {
        return GTLanguageManager.getTranslation("gt.blockmachines." + this.mName + ".name");
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isValidFacing(wrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(wrenchingSide);
            return true;
        }
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        IGregTechTileEntity gtTE;
        if (!aPlayer.func_70093_af()) {
            return false;
        }
        ForgeDirection oppositeSide = wrenchingSide.getOpposite();
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(wrenchingSide);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof MTECable) {
            return gtTE.getMetaTileEntity().onWireCutterRightClick(wrenchingSide, oppositeSide, aPlayer, aX, aY, aZ, aTool);
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        IGregTechTileEntity gtTE;
        if (!aPlayer.func_70093_af()) {
            return false;
        }
        ForgeDirection oppositeSide = wrenchingSide.getOpposite();
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(wrenchingSide);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof MTECable) {
            return gtTE.getMetaTileEntity().onSolderingToolRightClick(wrenchingSide, oppositeSide, aPlayer, aX, aY, aZ, aTool);
        }
        return false;
    }

    @Override
    public void onExplosion() {
        GTLog.exp.println("Machine at " + this.getBaseMetaTileEntity().getXCoord() + " | " + this.getBaseMetaTileEntity().getYCoord() + " | " + this.getBaseMetaTileEntity().getZCoord() + " DIMID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g + " exploded.");
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isServerSide() && aPlayer instanceof EntityPlayerMPAccessor) {
            this.playerLang = ((EntityPlayerMPAccessor)aPlayer).gt5u$getTranslator();
        }
        return this.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    protected String translate(String key) {
        String base = this.playerLang != null ? LanguageRegistry.instance().getStringLocalization(key, this.playerLang) : LanguageRegistry.instance().getStringLocalization(key);
        if (base.isEmpty()) {
            base = LanguageRegistry.instance().getStringLocalization(key, "en_US");
        }
        return base;
    }

    protected String translate(String key, Object ... params) {
        return String.format(this.translate(key), params);
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public SteamVariant getSteamVariant() {
        return SteamVariant.NONE;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isTransformingLowEnergy() {
        return true;
    }

    public long getEUVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        if (aEnergy != ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy) {
            this.func_70296_d();
            ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy = aEnergy;
        }
    }

    public long getSteamVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam;
    }

    public void setSteamVar(long aSteam) {
        if (((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam != aSteam) {
            this.func_70296_d();
            ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam = aSteam;
        }
    }

    public long maxSteamStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long getInputTier() {
        return GTUtility.getTier(this.getBaseMetaTileEntity().getInputVoltage());
    }

    public long getOutputTier() {
        return GTUtility.getTier(this.getBaseMetaTileEntity().getOutputVoltage());
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public boolean ownerControl() {
        return false;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return true;
    }

    public int getRealCapacity() {
        return this.getCapacity();
    }

    public void onFacingChange() {
    }

    public boolean isTeleporterCompatible() {
        return this.isEnetOutput() && this.getBaseMetaTileEntity().getOutputVoltage() >= 128L && this.getBaseMetaTileEntity().getUniversalEnergyCapacity() >= 500000L;
    }

    public boolean willExplodeInRain() {
        return true;
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        IConfigurationCircuitSupport ccs;
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IConfigurationCircuitSupport && (ccs = (IConfigurationCircuitSupport)((Object)metaTileEntity)).allowSelectCircuit() && aIndex == ccs.getCircuitSlot() && aStack != null) {
            this.mInventory[aIndex] = GTUtility.copyAmount(0, aStack);
            this.func_70296_d();
            return;
        }
        super.func_70299_a(aIndex, aStack);
        this.onContentsChanged(aIndex);
    }

    protected void onContentsChanged(int slot) {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public int fill_default(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        int filled = this.fill(aFluid, doFill);
        if (filled > 0) {
            this.func_70296_d();
        }
        return filled;
    }

    public int fill(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        if (this.getBaseMetaTileEntity().isSteampowered() && GTModHandler.isSteam(aFluid) && aFluid.amount > 1) {
            int tSteam = (int)Math.min(Integer.MAX_VALUE, Math.min((long)(aFluid.amount / 2), this.getBaseMetaTileEntity().getSteamCapacity() - this.getBaseMetaTileEntity().getStoredSteam()));
            if (tSteam > 0) {
                this.func_70296_d();
                if (doFill) {
                    this.getBaseMetaTileEntity().increaseStoredSteam(tSteam, true);
                }
                return tSteam * 2;
            }
        } else {
            return this.fill_default(side, aFluid, doFill);
        }
        return 0;
    }

    public void func_70296_d() {
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.func_70296_d();
        }
    }

    @Override
    public float getExplosionResistance(ForgeDirection side) {
        return 10.0f;
    }

    @Override
    public void onBlockDestroyed() {
        IGregTechTileEntity meta = this.getBaseMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            MetaPipeEntity neighbor;
            IGregTechTileEntity iGregTechTileEntity = meta.getIGregTechTileEntityAtSide(side);
            if (iGregTechTileEntity == null) continue;
            IMetaTileEntity iMetaTileEntity = iGregTechTileEntity.getMetaTileEntity();
            if (iMetaTileEntity instanceof MTEPipeLaser) {
                neighbor = (MTEPipeLaser)iMetaTileEntity;
                neighbor.mConnections = (byte)(neighbor.mConnections & ~side.getOpposite().flag);
                neighbor.connectionCount = (byte)(neighbor.connectionCount - 1);
            }
            if (!((iMetaTileEntity = iGregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeData)) continue;
            neighbor = (MTEPipeData)iMetaTileEntity;
            ((MTEPipeData)neighbor).mConnections = (byte)(((MTEPipeData)neighbor).mConnections & ~side.getOpposite().flag);
            ((MTEPipeData)neighbor).connectionCount = (byte)(((MTEPipeData)neighbor).connectionCount - 1);
        }
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        IGregTechTileEntity meta = this.getBaseMetaTileEntity();
        int aX = meta.getXCoord();
        short aY = meta.getYCoord();
        int aZ = meta.getZCoord();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            MetaPipeEntity pipe;
            IGregTechTileEntity iGregTechTileEntity;
            TileEntity tTileEntity = meta.getTileEntityAtSide(side);
            if (tTileEntity instanceof BaseMetaPipeEntity) {
                BaseMetaPipeEntity pipe2 = (BaseMetaPipeEntity)tTileEntity;
                pipe2.onNeighborBlockChange(aX, aY, aZ);
            }
            if ((iGregTechTileEntity = meta.getIGregTechTileEntityAtSide(side)) == null) continue;
            IMetaTileEntity iMetaTileEntity = iGregTechTileEntity.getMetaTileEntity();
            if (iMetaTileEntity instanceof MTEPipeLaser) {
                pipe = (MTEPipeLaser)iMetaTileEntity;
                ((MTEPipeLaser)pipe).updateNetwork(true);
            }
            if (!((iMetaTileEntity = iGregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeData)) continue;
            pipe = (MTEPipeData)iMetaTileEntity;
            ((MTEPipeData)pipe).updateNetwork(true);
        }
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = GTValues.getExplosionPowerForVoltage(aExplosionPower);
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        GTUtility.sendSoundToPlayers(tWorld, SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, 1.0f, -1.0f, tX, (int)tY, tZ);
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTechAPI.sMachineExplosions) {
            tWorld.func_72876_a(null, (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStrength, true);
        }
    }

    @Override
    public int getLightOpacity() {
        return ((BaseMetaTileEntity)this.getBaseMetaTileEntity()).getLightValue() > 0 ? 0 : 255;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    public boolean shouldTriggerBlockUpdate() {
        return false;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.NONE;
    }

    public AENetworkProxy getProxy() {
        return null;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineCraftingIcon() {
        return this.getStackForm(1L);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.facing", (Object[])new Object[]{MetaTileEntity.getFacingNameLocalized(this.mBaseMetaTileEntity.getFrontFacing().ordinal())}));
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IPowerChannelState) {
            IPowerChannelState state = (IPowerChannelState)metaTileEntity;
            NBTTagCompound tag = accessor.getNBTData();
            boolean isActive = tag.func_74767_n("isActive");
            boolean isPowered = tag.func_74767_n("isPowered");
            boolean isBooting = tag.func_74767_n("isBooting");
            currenttip.add(WailaText.getPowerState((boolean)isActive, (boolean)isPowered, (boolean)isBooting));
        }
    }

    @NotNull
    protected static String getFacingNameLocalized(int id) {
        if (id >= 0 && id < FACING_DIRECTION_NAMES.length) {
            return StatCollector.func_74838_a((String)FACING_DIRECTION_NAMES[id]);
        }
        return StatCollector.func_74838_a((String)"GT5U.waila.facing.unknown");
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IPowerChannelState) {
            IPowerChannelState state = (IPowerChannelState)metaTileEntity;
            boolean isActive = state.isActive();
            boolean isPowered = state.isPowered();
            boolean isBooting = state.isBooting();
            tag.func_74757_a("isActive", isActive);
            tag.func_74757_a("isPowered", isPowered);
            tag.func_74757_a("isBooting", isBooting);
        }
    }

    protected String getAEDiagnostics() {
        try {
            if (this.getProxy() == null) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.proxy");
            }
            if (this.getProxy().getNode() == null) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.node");
            }
            if (this.getProxy().getNode().getGrid() == null) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.grid");
            }
            if (!this.getProxy().getNode().meetsChannelRequirements()) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.channels");
            }
            IPathingGrid pg = (IPathingGrid)this.getProxy().getNode().getGrid().getCache(IPathingGrid.class);
            if (!pg.isNetworkBooting()) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.booting");
            }
            IEnergyGrid eg = (IEnergyGrid)this.getProxy().getNode().getGrid().getCache(IEnergyGrid.class);
            if (!eg.isNetworkPowered()) {
                return StatCollector.func_74838_a((String)"GT5U.infodata.hatch.me.diagnostics.power");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return "";
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.DEFAULT;
    }

    @Override
    public int getGUIColorization() {
        Dyes dye = Dyes.dyeWhite;
        if (this.colorOverride.sLoaded()) {
            if (this.colorOverride.sGuiTintingEnabled() && this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getOrDefault(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL);
                return this.colorOverride.getGuiTintOrDefault(dye.mName, dye.toInt());
            }
        } else if (GregTechAPI.sColoredGUI) {
            if (GregTechAPI.sMachineMetalGUI) {
                dye = Dyes.MACHINE_METAL;
            } else if (this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getOrDefault(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL);
            }
        }
        return dye.toInt();
    }

    @Override
    public int getTextColorOrDefault(String textType, int defaultColor) {
        return this.colorOverride.getTextColorOrDefault(textType, defaultColor);
    }

    public final byte getColor() {
        return this.getBaseMetaTileEntity().getColorization();
    }
}

