/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class OverclockCalculator {
    protected long recipeEUt = 0L;
    protected long machineVoltage = 0L;
    protected long machineAmperage = 1L;
    protected int duration = 0;
    protected Supplier<Double> durationUnderOneTickSupplier;
    protected int parallel = 1;
    protected int maxTierSkip = 1;
    protected double eutModifier = 1.0;
    protected double durationModifier = 1.0;
    protected double eutIncreasePerOC = 4.0;
    protected double durationDecreasePerOC = 2.0;
    protected boolean laserOC;
    protected boolean amperageOC;
    protected int maxOverclocks = Integer.MAX_VALUE;
    protected int maxRegularOverclocks = Integer.MAX_VALUE;
    protected int overclocks = 0;
    protected boolean noOverclock;
    protected int currentParallel;
    protected int recipeHeat = 0;
    protected int machineHeat = 0;
    protected final double durationDecreasePerHeatOC = 4.0;
    protected boolean heatOC;
    protected boolean heatDiscount;
    protected double heatDiscountExponent = 0.95;
    protected boolean calculated;
    protected int calculatedDuration;
    protected long calculatedConsumption;
    protected static final int HEAT_DISCOUNT_THRESHOLD = 900;
    protected static final int HEAT_OVERCLOCK_THRESHOLD = 1800;

    public static OverclockCalculator ofNoOverclock(@Nonnull GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe.mEUt, recipe.mDuration);
    }

    public static OverclockCalculator ofNoOverclock(long eut, int duration) {
        return new OverclockCalculator().setRecipeEUt(eut).setDuration(duration).setEUt(eut).setNoOverclock(true);
    }

    @Nonnull
    public OverclockCalculator setRecipeEUt(long recipeEUt) {
        this.recipeEUt = recipeEUt;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUt(long machineVoltage) {
        this.machineVoltage = machineVoltage;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperage(long machineAmperage) {
        this.machineAmperage = machineAmperage;
        return this;
    }

    @Nonnull
    public OverclockCalculator enablePerfectOC() {
        this.durationDecreasePerOC = 4.0;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatOC(boolean heatOC) {
        this.heatOC = heatOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscount(boolean heatDiscount) {
        this.heatDiscount = heatDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setRecipeHeat(int recipeHeat) {
        this.recipeHeat = recipeHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setMachineHeat(int machineHeat) {
        this.machineHeat = machineHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtDiscount(double aEUtDiscount) {
        this.eutModifier = aEUtDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationModifier(double aSpeedBoost) {
        this.durationModifier = aSpeedBoost;
        return this;
    }

    @Nonnull
    public OverclockCalculator setParallel(int aParallel) {
        this.parallel = aParallel;
        return this;
    }

    @Nonnull
    public OverclockCalculator setMaxTierSkips(int aMaxTierSkips) {
        this.maxTierSkip = aMaxTierSkips;
        return this;
    }

    @Nonnull
    public OverclockCalculator setUnlimitedTierSkips() {
        this.maxTierSkip = Integer.MAX_VALUE;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscountMultiplier(double heatDiscountExponent) {
        this.heatDiscountExponent = heatDiscountExponent;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtIncreasePerOC(double eutIncreasePerOC) {
        if (eutIncreasePerOC <= 0.0) {
            throw new IllegalArgumentException("EUt increase can't be a negative number or zero");
        }
        this.eutIncreasePerOC = eutIncreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationDecreasePerOC(double durationDecreasePerOC) {
        if (durationDecreasePerOC <= 0.0) {
            throw new IllegalArgumentException("Duration decrease can't be a negative number or zero");
        }
        this.durationDecreasePerOC = durationDecreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setMaxOverclocks(int maxOverclocks) {
        this.maxOverclocks = Math.max(maxOverclocks, 0);
        return this;
    }

    @Nonnull
    public OverclockCalculator setMaxRegularOverclocks(int maxRegularOverclocks) {
        this.maxRegularOverclocks = Math.max(maxRegularOverclocks, 0);
        return this;
    }

    @Nonnull
    public OverclockCalculator setLaserOC(boolean laserOC) {
        this.laserOC = laserOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationUnderOneTickSupplier(Supplier<Double> supplier) {
        this.durationUnderOneTickSupplier = supplier;
        return this;
    }

    @Nonnull
    public OverclockCalculator setNoOverclock(boolean noOverclock) {
        this.noOverclock = noOverclock;
        return this;
    }

    public OverclockCalculator setCurrentParallel(int currentParallel) {
        this.currentParallel = currentParallel;
        this.parallel = Math.min(this.parallel, currentParallel);
        return this;
    }

    public long getConsumption() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get consumption before calculating");
        }
        return this.calculatedConsumption;
    }

    public int getDuration() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get duration before calculating");
        }
        return this.calculatedDuration;
    }

    public int getPerformedOverclocks() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get performed overclocks before calculating");
        }
        return this.overclocks;
    }

    public boolean getAllowedTierSkip() {
        if (this.maxTierSkip == Integer.MAX_VALUE) {
            return true;
        }
        return (double)this.recipeEUt <= (double)this.machineVoltage * GTUtility.powInt(4.0, this.maxTierSkip);
    }

    public boolean hasDurationUnderOneTickSupplier() {
        return this.durationUnderOneTickSupplier != null;
    }

    public double getDurationUnderOneTickSupplier() {
        return this.durationUnderOneTickSupplier.get();
    }

    @Nonnull
    public OverclockCalculator calculate() {
        if (this.calculated) {
            throw new IllegalStateException("Tried to calculate overclocks twice");
        }
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    public double calculateHeatDiscountMultiplier() {
        int heatDiscounts = this.heatDiscount ? (this.machineHeat - this.recipeHeat) / 900 : 0;
        return GTUtility.powInt(this.heatDiscountExponent, heatDiscounts);
    }

    protected void calculateOverclock() {
        double duration = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.durationModifier;
        this.currentParallel = Math.max(this.currentParallel, this.parallel);
        double recipePower = (double)(this.recipeEUt * (long)this.parallel) * this.eutModifier * this.calculateHeatDiscountMultiplier();
        double machinePower = this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel));
        int tiersAbove = (int)GTUtility.log4((long)machinePower / Math.max((long)recipePower, 32L));
        if (this.noOverclock) {
            this.calculatedConsumption = (long)Math.ceil(recipePower);
            this.calculatedDuration = (int)Math.ceil(duration);
            return;
        }
        if (this.laserOC) {
            int regularOverclocks;
            double eutOverclock = recipePower;
            for (regularOverclocks = 0; eutOverclock * 4.0 < machinePower && regularOverclocks < this.maxRegularOverclocks; ++regularOverclocks) {
                eutOverclock *= 4.0;
            }
            double durationPerSlice = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : duration;
            int laserOverclocks = 0;
            while (true) {
                double multiplier = 4.0 + 0.3 * (double)(laserOverclocks + 1);
                double potentialEU = eutOverclock * multiplier;
                double estimatedDuration = duration / Math.pow(this.durationDecreasePerOC, regularOverclocks + laserOverclocks + 1);
                if (potentialEU >= machinePower || estimatedDuration <= duration / durationPerSlice) break;
                eutOverclock = potentialEU;
                ++laserOverclocks;
            }
            this.overclocks = regularOverclocks + laserOverclocks;
            this.calculatedConsumption = (long)Math.ceil(eutOverclock);
            this.calculatedDuration = (int)Math.max(duration / GTUtility.powInt(this.durationDecreasePerOC, this.overclocks), 1.0);
            return;
        }
        this.overclocks = Math.min(this.maxOverclocks, tiersAbove);
        if (!this.amperageOC) {
            int voltageTierMachine = (int)Math.max(GTUtility.log4ceil(this.machineVoltage / 8L), 1L);
            int voltageTierRecipe = (int)Math.max(GTUtility.log4ceil(this.recipeEUt / 8L), 1L);
            this.overclocks = Math.min(this.overclocks, voltageTierMachine - voltageTierRecipe);
        }
        this.overclocks = Math.max(this.overclocks, 0);
        int heatOverclocks = Math.min(this.heatOC ? (this.machineHeat - this.recipeHeat) / 1800 : 0, this.overclocks);
        int regularOverclocks = this.overclocks - heatOverclocks;
        this.calculatedConsumption = (long)Math.ceil(recipePower * GTUtility.powInt(this.eutIncreasePerOC, this.overclocks));
        duration /= GTUtility.powInt(4.0, heatOverclocks);
        this.calculatedDuration = (int)Math.max(duration /= GTUtility.powInt(this.durationDecreasePerOC, regularOverclocks), 1.0);
    }

    public double calculateMultiplierUnderOneTick() {
        double correctionMultiplier;
        int neededOverclocks = 0;
        if (this.noOverclock) {
            return 1.0;
        }
        double duration = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.durationModifier;
        double recipePower = (double)(this.recipeEUt * (long)this.parallel) * this.eutModifier * this.calculateHeatDiscountMultiplier();
        double machinePower = this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel));
        int voltageTierRecipe = (int)Math.max(GTUtility.log4ceil(this.recipeEUt / 8L), 1L);
        int voltageTierMachine = (int)Math.max(GTUtility.log4ceil(this.machineVoltage / 8L), 1L);
        int powerTiersAbove = (int)GTUtility.log4((long)machinePower / Math.max((long)recipePower, 32L));
        int voltageTiersAbove = voltageTierMachine - voltageTierRecipe;
        if (this.laserOC) {
            int regularOverclocks;
            double eutOverclock = recipePower;
            for (regularOverclocks = 0; eutOverclock * 4.0 < machinePower && regularOverclocks < this.maxRegularOverclocks; ++regularOverclocks) {
                eutOverclock *= 4.0;
                if (!(duration / GTUtility.powInt(this.durationDecreasePerOC, this.overclocks) < 2.0) || neededOverclocks != 0) continue;
                neededOverclocks = regularOverclocks;
            }
            int laserOverclocks = 0;
            while (eutOverclock * (4.0 + 0.3 * (double)(laserOverclocks + 1)) < machinePower) {
                eutOverclock *= 4.0 + 0.3 * (double)(laserOverclocks + 1);
                ++laserOverclocks;
                if (!(duration / GTUtility.powInt(this.durationDecreasePerOC, this.overclocks) < 2.0) || neededOverclocks != 0) continue;
                neededOverclocks = this.overclocks + laserOverclocks;
            }
            int overclocks = regularOverclocks + laserOverclocks;
            return GTUtility.powInt(this.durationDecreasePerOC, Math.max(neededOverclocks - overclocks, 0));
        }
        int overclocks = GTUtility.clamp(this.maxOverclocks, 0, this.amperageOC ? powerTiersAbove : voltageTiersAbove);
        int heatOverclocks = Math.min(this.heatOC ? (this.machineHeat - this.recipeHeat) / 1800 : 0, overclocks);
        int regularOverclocks = overclocks - heatOverclocks;
        double durationAfterHeatOC = duration / GTUtility.powInt(4.0, heatOverclocks);
        int neededHeatOverclocks = (int)Math.ceil(Math.log(duration) / Math.log(4.0));
        int neededRegularOverclocks = (int)Math.ceil(Math.log(durationAfterHeatOC) / Math.log(this.durationDecreasePerOC));
        int extraHeatOverclocks = Math.max(heatOverclocks - neededHeatOverclocks, 0);
        int extraRegularOverclocks = Math.max(regularOverclocks - neededRegularOverclocks, 0);
        int heatMultiplier = (int)GTUtility.powInt(4.0, extraHeatOverclocks);
        int regularMultiplier = (int)GTUtility.powInt(this.durationDecreasePerOC, extraRegularOverclocks);
        if (heatOverclocks >= neededHeatOverclocks) {
            correctionMultiplier = GTUtility.powInt(4.0, neededHeatOverclocks) / duration;
        } else if (regularOverclocks >= neededRegularOverclocks) {
            correctionMultiplier = GTUtility.powInt(this.durationDecreasePerOC, neededRegularOverclocks) / durationAfterHeatOC;
        } else {
            return 1.0;
        }
        return Math.ceil((double)(heatMultiplier * regularMultiplier) * correctionMultiplier);
    }
}

