/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.cleanroommc.modularui.utils.item.ItemStackHandler;
import com.cleanroommc.modularui.utils.item.LimitingItemStackHandler;
import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTByteBuffer;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverItemFilterGui;
import gregtech.common.covers.modes.FilterType;
import gregtech.common.gui.mui1.cover.ItemFilterUIFactory;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverItemFilter
extends Cover {
    private final boolean mExport;
    private boolean mWhitelist;
    private ItemStackHandler filter = new LimitingItemStackHandler(1, 1);

    public CoverItemFilter(CoverContext context, boolean isExport, ITexture coverTexture) {
        super(context, coverTexture);
        this.mExport = isExport;
        this.mWhitelist = false;
    }

    public boolean isWhitelist() {
        return this.mWhitelist;
    }

    public CoverItemFilter setWhitelist(boolean whitelist) {
        this.mWhitelist = whitelist;
        return this;
    }

    public ItemStackHandler getFilter() {
        return this.filter;
    }

    public CoverItemFilter setFilter(ItemStackHandler filter) {
        this.filter = filter;
        return this;
    }

    public FilterType getFilterType() {
        return this.mWhitelist ? FilterType.BLACKLIST : FilterType.WHITELIST;
    }

    public void setFilterType(FilterType filterType) {
        this.mWhitelist = filterType == FilterType.BLACKLIST;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.mWhitelist = tag.func_74767_n("mWhitelist");
        if (tag.func_150297_b("mFilter", 10)) {
            this.filter = new ItemStackHandler(1);
            this.filter.setStackInSlot(0, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mFilter")));
        } else {
            this.filter.deserializeNBT(tag.func_74775_l("filter"));
        }
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.mWhitelist = byteData.readBoolean();
        this.filter.deserializeNBT(GTByteBuffer.readCompoundTagFromGreggyByteBuf(byteData));
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("mWhitelist", this.mWhitelist);
        tag.func_74782_a("filter", (NBTBase)this.filter.serializeNBT());
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeBoolean(this.mWhitelist);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)this.filter.serializeNBT());
    }

    public boolean isRedstoneSensitive() {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        TileEntity tTileEntity = coverable.getTileEntityAtSide(this.coverSide);
        ICoverable fromEntity = this.mExport ? coverable : tTileEntity;
        ICoverable toEntity = !this.mExport ? coverable : tTileEntity;
        ForgeDirection fromSide = !this.mExport ? this.coverSide.getOpposite() : this.coverSide;
        ForgeDirection toSide = this.mExport ? this.coverSide.getOpposite() : this.coverSide;
        List<ItemStack> filter = Collections.singletonList(this.filter.getStackInSlot(0));
        GTUtility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, filter, this.mWhitelist, (byte)64, (byte)1, (byte)64, (byte)1, 64);
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
        if (tStack != null) {
            this.filter.setStackInSlot(0, tStack);
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("299", "Item Filter: ") + tStack.func_82833_r());
        } else {
            this.filter.setStackInSlot(0, null);
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("300", "Filter Cleared!"));
        }
        return true;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mWhitelist = !this.mWhitelist;
        GTUtility.sendChatToPlayer(aPlayer, this.mWhitelist ? GTUtility.trans("124.1", "Blacklist Mode") : GTUtility.trans("125.1", "Whitelist Mode"));
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverItemFilterGui(this);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ItemFilterUIFactory(buildContext).createWindow();
    }
}

