/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.data.maglev;

import com.gtnewhorizon.gtnhlib.datastructs.space.ArrayProximityMap4D;
import com.gtnewhorizon.gtnhlib.datastructs.space.VolumeShape;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.tileentities.machines.basic.MTEMagLevPylon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class TetherManager {
    private final ArrayProximityMap4D<MTEMagLevPylon> ACTIVE_PYLONS = new ArrayProximityMap4D(VolumeShape.CUBE);
    private final Map<EntityPlayerMP, MTEMagLevPylon> PLAYER_TETHERS = new HashMap<EntityPlayerMP, MTEMagLevPylon>();

    public void registerPylon(IGregTechTileEntity mte, MTEMagLevPylon tether, int range) {
        this.ACTIVE_PYLONS.put((Object)tether, mte.getWorld().field_73011_w.field_76574_g, mte.getXCoord(), (int)mte.getYCoord(), mte.getZCoord(), range);
    }

    public void unregisterPylon(IGregTechTileEntity mte) {
        this.ACTIVE_PYLONS.remove(mte.getWorld().field_73011_w.field_76574_g, mte.getXCoord(), (int)mte.getYCoord(), mte.getZCoord());
    }

    public MTEMagLevPylon getClosestActivePylon(EntityPlayer player) {
        return (MTEMagLevPylon)this.ACTIVE_PYLONS.getClosest(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void connectPlayer(EntityPlayer player, MTEMagLevPylon tether) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            tether.connectPlayer();
            this.PLAYER_TETHERS.put(playerMP, tether);
        }
    }

    public void disconnectPlayer(EntityPlayer player) {
        EntityPlayerMP playerMP;
        MTEMagLevPylon removed;
        if (player instanceof EntityPlayerMP && (removed = this.PLAYER_TETHERS.remove(playerMP = (EntityPlayerMP)player)) != null) {
            removed.disconnectPlayer();
        }
    }

    public MTEMagLevPylon getConnectedPylon(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            return this.PLAYER_TETHERS.get(playerMP);
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.disconnectPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.disconnectPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        Entity entity;
        if (!event.entity.field_70170_p.field_72995_K && (entity = event.entity) instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            this.disconnectPlayer((EntityPlayer)playerMP);
        }
    }
}

