/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.util;

import com.cleanroommc.modularui.drawable.UITexture;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SteamVariant;

public class SteamTextureRegisterer {
    private final UITexture.Builder bronzeBuilder = UITexture.builder();
    private final UITexture.Builder steelBuilder = UITexture.builder();
    private final UITexture.Builder primitiveBuilder = UITexture.builder();

    public static SteamTextureRegisterer builder() {
        return new SteamTextureRegisterer();
    }

    private SteamTextureRegisterer() {
    }

    public SteamTextureRegisterer location(String pathPlaceholder) {
        this.bronzeBuilder.location(Mods.GregTech.ID, String.format(pathPlaceholder, new Object[]{SteamVariant.BRONZE}));
        this.steelBuilder.location(Mods.GregTech.ID, String.format(pathPlaceholder, new Object[]{SteamVariant.STEEL}));
        this.primitiveBuilder.location(Mods.GregTech.ID, String.format(pathPlaceholder, new Object[]{SteamVariant.PRIMITIVE}));
        return this;
    }

    public SteamTextureRegisterer imageSize(int w, int h) {
        this.bronzeBuilder.imageSize(w, h);
        this.steelBuilder.imageSize(w, h);
        this.primitiveBuilder.imageSize(w, h);
        return this;
    }

    public SteamTextureRegisterer fullImage() {
        this.bronzeBuilder.fullImage();
        this.steelBuilder.fullImage();
        this.primitiveBuilder.fullImage();
        return this;
    }

    public SteamTextureRegisterer adaptable(int border) {
        this.bronzeBuilder.adaptable(border);
        this.steelBuilder.adaptable(border);
        this.primitiveBuilder.adaptable(border);
        return this;
    }

    public SteamTextureRegisterer canApplyTheme() {
        this.bronzeBuilder.canApplyTheme();
        this.steelBuilder.canApplyTheme();
        this.primitiveBuilder.canApplyTheme();
        return this;
    }

    public SteamTextureRegisterer name(String bronzeName, String steelName, String primitiveName) {
        this.bronzeBuilder.name(bronzeName);
        this.steelBuilder.name(steelName);
        this.primitiveBuilder.name(primitiveName);
        return this;
    }

    public SteamTextureRegisterer build() {
        this.bronzeBuilder.build();
        this.steelBuilder.build();
        this.primitiveBuilder.build();
        return this;
    }
}

