/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGenRecycling
implements Runnable {
    public static ArrayList<Runnable> mQueuedRecyclingGenerators = new ArrayList();
    final Material toGenerate;

    public static void executeGenerators() {
        if (!mQueuedRecyclingGenerators.isEmpty()) {
            for (Runnable R : mQueuedRecyclingGenerators) {
                R.run();
            }
        }
    }

    public RecipeGenRecycling(Material M) {
        this.toGenerate = M;
        mQueuedRecyclingGenerators.add(this);
    }

    @Override
    public void run() {
        RecipeGenRecycling.generateRecipes(this.toGenerate);
    }

    public static void generateRecipes(Material material) {
        Pair[] temp;
        if (material != null) {
            Logger.WARNING("Generating Recycling recipes for " + material.getLocalizedName());
        }
        OrePrefixes[] mValidPrefixesAsString = new OrePrefixes[]{OrePrefixes.ingot, OrePrefixes.ingotHot, OrePrefixes.nugget, OrePrefixes.plate, OrePrefixes.plateDense, OrePrefixes.plateDouble, OrePrefixes.plateTriple, OrePrefixes.plateQuadruple, OrePrefixes.plateQuintuple, OrePrefixes.stick, OrePrefixes.stickLong, OrePrefixes.bolt, OrePrefixes.screw, OrePrefixes.ring, OrePrefixes.rotor, OrePrefixes.gearGt, OrePrefixes.gearGtSmall, OrePrefixes.block, OrePrefixes.cableGt01, OrePrefixes.cableGt02, OrePrefixes.cableGt04, OrePrefixes.cableGt08, OrePrefixes.cableGt12, OrePrefixes.wireFine, OrePrefixes.wireGt01, OrePrefixes.wireGt02, OrePrefixes.wireGt04, OrePrefixes.wireGt08, OrePrefixes.wireGt12, OrePrefixes.wireGt16, OrePrefixes.foil, OrePrefixes.frameGt, OrePrefixes.pipeHuge, OrePrefixes.pipeLarge, OrePrefixes.pipeMedium, OrePrefixes.pipeSmall, OrePrefixes.pipeTiny};
        int mSlotIndex = 0;
        Pair[] mValidPairs = new Pair[mValidPrefixesAsString.length];
        for (int r = 0; r < mValidPairs.length; ++r) {
            temp = RecipeGenRecycling.getItemStackOfAmountFromOreDictNoBroken(mValidPrefixesAsString[r].name() + StringUtils.sanitizeString(material.getLocalizedName()), 1);
            if (temp == null) continue;
            mValidPairs[mSlotIndex++] = Pair.of((Object)((Object)mValidPrefixesAsString[r]), (Object)temp.func_77946_l());
        }
        int validCounter = 0;
        temp = mValidPairs;
        for (ItemStack itemStack : mValidPairs) {
            if (itemStack == null) continue;
            Logger.WARNING("Valid: " + ((ItemStack)itemStack.getValue()).func_82833_r());
            ++validCounter;
        }
        Pair[] temp3 = new Pair[validCounter];
        int temp4 = 0;
        for (ItemStack itemStack : mValidPairs) {
            if (itemStack == null) continue;
            temp3[temp4++] = itemStack;
        }
        if (temp3.length > 0) {
            mValidPairs = (Pair[])temp3.clone();
        }
        for (Pair pair : mValidPairs) {
            if (material == null || pair == null || material.getState() != MaterialState.SOLID && material.getState() != MaterialState.LIQUID || pair.getKey() == OrePrefixes.ingotHot) continue;
            ItemStack tempStack = (ItemStack)pair.getValue();
            ItemStack mDust = RecipeGenRecycling.getDust(material, (OrePrefixes)((Object)pair.getKey()));
            if (tempStack != null && mDust != null) {
                GTValues.RA.stdBuilder().itemInputs(tempStack).itemOutputs(mDust).eut(2).duration(400).addTo(RecipeMaps.maceratorRecipes);
                Logger.WARNING("Recycle Recipe: " + material.getLocalizedName() + " - Success - Recycle " + tempStack.func_82833_r() + " and obtain " + mDust.func_82833_r());
            }
            if (tempStack == null) continue;
            int aFluidAmount = (int)(144L * ((OrePrefixes)((Object)pair.getKey())).mMaterialAmount / (3628800L * (long)tempStack.field_77994_a));
            int aDuration = (int)Math.max(1L, 24L * ((OrePrefixes)((Object)pair.getKey())).mMaterialAmount / 3628800L);
            FluidStack fluidOutput = material.getFluidStack(aFluidAmount);
            if (fluidOutput == null) continue;
            GTValues.RA.stdBuilder().itemInputs(tempStack).fluidOutputs(fluidOutput).duration(aDuration).eut(material.vVoltageMultiplier).addTo(RecipeMaps.fluidExtractionRecipes);
            Logger.WARNING("Fluid Recycle Recipe: " + material.getLocalizedName() + " - Success - Recycle " + tempStack.func_82833_r() + " and obtain " + aFluidAmount + "mb of " + material.getFluidStack(1).getLocalizedName() + ". Time: " + aDuration + ", Voltage: " + material.vVoltageMultiplier);
        }
    }

    public static Pair<OrePrefixes, ItemStack> getDustData(Material aMaterial, OrePrefixes aPrefix) {
        return RecipeGenRecycling.getDustData(aMaterial, aPrefix.mMaterialAmount);
    }

    public static Pair<OrePrefixes, ItemStack> getDustData(Material aMaterial, long aMaterialAmount) {
        ItemStack mDust = null;
        OrePrefixes mPrefix = null;
        if (aMaterial == null || aMaterialAmount <= 0L) {
            return null;
        }
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            mDust = RecipeGenRecycling.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
            mPrefix = OrePrefixes.dust;
        }
        if (mDust == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            mDust = RecipeGenRecycling.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
            mPrefix = OrePrefixes.dustSmall;
        }
        if (mDust == null && aMaterialAmount * 9L >= 3628800L) {
            mDust = RecipeGenRecycling.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
            mPrefix = OrePrefixes.dustTiny;
        }
        if (mPrefix != null && mDust != null) {
            Logger.WARNING("Built valid dust pair.");
            return Pair.of((Object)((Object)mPrefix), (Object)mDust);
        }
        Logger.WARNING("mPrefix: " + (mPrefix != null));
        Logger.WARNING("mDust: " + (mDust != null));
        Logger.WARNING("Failed to build valid dust pair.");
        return null;
    }

    public static ItemStack getDust(Material aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : RecipeGenRecycling.getDust(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getDust(Material aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            Logger.WARNING("Trying to get a Dust");
            rStack = RecipeGenRecycling.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            Logger.WARNING("Trying to get a Small Dust");
            rStack = RecipeGenRecycling.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            Logger.WARNING("Trying to get a Tiny Dust");
            rStack = RecipeGenRecycling.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack get(Object aName, long aAmount) {
        return RecipeGenRecycling.get(aName, null, aAmount, true, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount) {
        return RecipeGenRecycling.get(aName, aReplacement, aAmount, true, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Material aMaterial, long aAmount) {
        return RecipeGenRecycling.get(aPrefix, aMaterial, null, aAmount);
    }

    public static ItemStack get(OrePrefixes aPrefix, Material aMaterial, ItemStack aReplacement, long aAmount) {
        return RecipeGenRecycling.get(aPrefix.name() + StringUtils.sanitizeString(aMaterial.getLocalizedName()), aReplacement, aAmount, false, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        if (aNoInvalidAmounts && aAmount < 1L) {
            Logger.modLogger.warn("Returning Null. Method: ", (Throwable)new Exception());
            return null;
        }
        if (!GTOreDictUnificator.getName2StackMap().containsKey(aName.toString()) && aMentionPossibleTypos) {
            Logger.WARNING("Unknown Key for Unification, Typo? " + aName);
        }
        return GTUtility.copyAmount(aAmount, GTOreDictUnificator.getName2StackMap().get(aName.toString()), RecipeGenRecycling.getFirstOre(aName, aAmount), aReplacement);
    }

    public static ItemStack getFirstOre(Object aName, long aAmount) {
        if (GTUtility.isStringInvalid(aName)) {
            Logger.modLogger.warn("Returning Null. Method: ", (Throwable)new Exception());
            return null;
        }
        ItemStack tStack = GTOreDictUnificator.getName2StackMap().get(aName.toString());
        if (GTUtility.isStackValid(tStack)) {
            Logger.WARNING("Found valid stack.");
            return GTUtility.copyAmount(aAmount, new Object[]{tStack});
        }
        return GTUtility.copyAmount(aAmount, RecipeGenRecycling.getOres(aName).toArray());
    }

    public static ArrayList<ItemStack> getOres(Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GTUtility.isStringValid(aName)) {
            Logger.WARNING("Making a list of all OreDict entries for " + aOreName + ".");
            if (rList.addAll(OreDictionary.getOres((String)aName))) {
                Logger.WARNING("Added " + rList.size() + " elements to list.");
            } else {
                Logger.WARNING("Failed to Add Collection from oreDictionary, forcing an entry.");
                rList.add(ItemUtils.getItemStackOfAmountFromOreDict((String)aOreName, 1));
            }
        }
        return rList;
    }

    public static ItemStack getItemStackOfAmountFromOreDictNoBroken(String oredictName, int amount) {
        String MaterialName;
        Materials m;
        oredictName = oredictName.contains("-") || oredictName.contains("_") ? StringUtils.sanitizeStringKeepDashes(oredictName) : StringUtils.sanitizeString(oredictName);
        ItemStack returnValue = null;
        if (oredictName.toLowerCase().contains("dust") && (m = Materials.get(MaterialName = oredictName.toLowerCase().replace("dust", ""))) != null && m != Materials._NULL && (returnValue = GTOreDictUnificator.get(OrePrefixes.dust, m, 1L)) != null) {
            return returnValue;
        }
        if (returnValue == null && (returnValue = RecipeGenRecycling.getItemStackOfAmountFromOreDict(oredictName, amount)) != null) {
            return returnValue.func_77946_l();
        }
        return null;
    }

    public static ItemStack getItemStackOfAmountFromOreDict(String oredictName, int amount) {
        if (oredictName.toLowerCase().contains("ingotclay")) {
            return new ItemStack(Items.field_151119_aD, amount);
        }
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            ItemStack returnValue = ((ItemStack)oreDictList.get(0)).func_77946_l();
            returnValue.field_77994_a = amount;
            return returnValue;
        }
        return null;
    }
}

