/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.util.GTModHandler;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;

public class RecipeGenShapedCrafting
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenShapedCrafting(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        Logger.WARNING("Generating Shaped Crafting recipes for " + material.getLocalizedName());
        if (material.getPlate(1) != null && material.getIngot(1) != null && material.getPlate(1) != null && material.getIngot(1) != null) {
            GTModHandler.addCraftingRecipe(material.getPlate(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"h", "B", "I", Character.valueOf('I'), material.getIngot(1), Character.valueOf('B'), material.getIngot(1)});
        }
        if (material.getPlateDouble(1) != null && material.getPlate(1) != null) {
            GTModHandler.addCraftingRecipe(material.getPlateDouble(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), material.getPlate(1), Character.valueOf('B'), material.getPlate(1)});
        }
        if (!material.isRadioactive && material.getRing(1) != null && material.getRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getRing(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"h ", "fR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("GT:NH Ring Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("GT:NH Ring Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getFrameBox(1) != null && material.getRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getFrameBox(2), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"RRR", "RwR", "RRR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Framebox Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Framebox Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getBolt(1) != null && material.getRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getBolt(2), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"s ", " R", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Bolt Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bolt Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getFoil(1) != null && material.getFineWire(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getFineWire(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"Fx", Character.valueOf('F'), material.getFoil(1)})) {
                Logger.WARNING("Fine Wire Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Fine Wire Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (material.getFoil(1) != null && material.getPlate(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getFoil(2), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"hP", Character.valueOf('P'), material.getPlate(1)})) {
                Logger.WARNING("Foil Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Foil Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (material.getRod(1) != null && material.getIngot(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getRod(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"f ", " I", Character.valueOf('I'), material.getIngot(1)})) {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (material.getRod(1) != null && material.getLongRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getRod(2), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"s", "L", Character.valueOf('L'), material.getLongRod(1)})) {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (material.getLongRod(1) != null && material.getRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getLongRod(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"RhR", Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Long Rod Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Long Rod Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getRotor(1) != null && material.getRing(1) != null && !material.isRadioactive && material.getPlate(1) != null && material.getScrew(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getRotor(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), material.getPlate(1), Character.valueOf('S'), material.getScrew(1), Character.valueOf('R'), material.getRing(1)})) {
                Logger.WARNING("Rotor Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Rotor Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getGear(1) != null && material.getPlate(1) != null && material.getRod(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getGear(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"RPR", "PwP", "RPR", Character.valueOf('P'), material.getPlate(1), Character.valueOf('R'), material.getRod(1)})) {
                Logger.WARNING("Gear Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Gear Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (!material.isRadioactive && material.getScrew(1) != null && material.getBolt(1) != null) {
            if (GTModHandler.addCraftingRecipe(material.getScrew(1), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"fB", "B ", Character.valueOf('B'), material.getBolt(1)})) {
                Logger.WARNING("Screw Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Screw Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

