/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.beamline;

import net.minecraft.util.StatCollector;

public enum Particle {
    ELECTRON(true, 0, 0.511f, 5000.0f, "electron", "e\u207b", -1.0f, null),
    PHOTON(false, 1, 0.0f, 0.0f, "photon", "\u03b3", 0.0f, null),
    NEUTRON(false, 2, 939.57f, 15000.0f, "neutron", "n\u2070", 0.0f, null),
    PROTON(true, 3, 938.27f, 15000.0f, "proton", "p\u207a", 1.0f, null),
    ALPHA(true, 4, 3727.38f, 8000.0f, "alpha", "\u03b1", 2.0f, null);

    public static final Particle[] VALUES;
    private final boolean canAcc;
    private final float restMass;
    private final float maxSourceEnergy;
    private final String name;
    private final String shortName;
    private final float charge;
    private final String chargeSpecial;

    private Particle(boolean canAcc, int id, float restMass, float maxSourceEnergy, String name, String shortName, float charge, String chargeSpecial) {
        this.canAcc = canAcc;
        this.restMass = restMass;
        this.maxSourceEnergy = maxSourceEnergy;
        this.name = name;
        this.shortName = shortName;
        this.charge = charge;
        this.chargeSpecial = chargeSpecial;
    }

    public float getMass() {
        return this.restMass;
    }

    public float getCharge() {
        return this.charge;
    }

    public String getChargeSpecial() {
        return this.chargeSpecial;
    }

    public boolean canAccelerate() {
        return this.canAcc;
    }

    public float maxSourceEnergy() {
        return this.maxSourceEnergy;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalisedName() {
        return StatCollector.func_74838_a((String)("particle." + this.name)) + " (" + this.shortName + ")";
    }

    public static Particle getParticleFromId(int id) {
        return Particle.values()[id];
    }

    static {
        VALUES = Particle.values();
    }
}

