/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.enderStorage;

import com.google.common.base.Objects;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import java.io.Serializable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderLinkTank
implements Serializable {
    private static final long serialVersionUID = 1030297456736434221L;
    private final int X;
    private final int Y;
    private final int Z;
    private final int D;

    public EnderLinkTank(IFluidHandler fluidHandler) {
        TileEntity tile = (TileEntity)fluidHandler;
        this.X = tile.field_145851_c;
        this.Y = tile.field_145848_d;
        this.Z = tile.field_145849_e;
        this.D = tile.func_145831_w().field_73011_w.field_76574_g;
    }

    private EnderLinkTank(int x, int y, int z, int d) {
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.D = d;
    }

    public boolean shouldSave() {
        WorldServer world = DimensionManager.getWorld((int)this.D);
        if (world == null || !world.func_72899_e(this.X, this.Y, this.Z)) {
            return true;
        }
        TileEntity tile = world.func_147438_o(this.X, this.Y, this.Z);
        return tile instanceof IFluidHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnderLinkTank that = (EnderLinkTank)o;
        return this.X == that.X && this.Y == that.Y && this.Z == that.Z && this.D == that.D;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.X, this.Y, this.Z, this.D});
    }

    public NBTTagCompound save() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("coords", CoordinatePacker.pack((int)this.X, (int)this.Y, (int)this.Z));
        data.func_74768_a("dim", this.D);
        return data;
    }

    public static EnderLinkTank load(NBTTagCompound data) {
        long coords = data.func_74763_f("coords");
        int dim = data.func_74762_e("dim");
        return new EnderLinkTank(CoordinatePacker.unpackX((long)coords), CoordinatePacker.unpackY((long)coords), CoordinatePacker.unpackZ((long)coords), dim);
    }
}

