/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.single;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaserMirror;
import tectech.util.CommonValues;

public class MTEDebugPowerGenerator
extends MTETieredMachineBlock
implements IConnectsToEnergyTunnel,
IAddUIWidgets,
IAddGregtechLogo {
    public static ITexture GENNY;
    private boolean LASER = false;
    public int EUT = 0;
    public int AMP = 0;
    public boolean producing = true;
    private static final NumberFormatMUI numberFormat;

    public MTEDebugPowerGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.3"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.2")}, new ITexture[0]);
    }

    public MTEDebugPowerGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDebugPowerGenerator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.LASER = !this.LASER;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"tt.chat.debug.generator", (Object[])new Object[]{this.LASER ? "ON" : "OFF"}));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        GENNY = TextureFactory.of(new Textures.BlockIcons.CustomIcon("iconsets/GENNY"));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1];
        iTextureArray[1] = side != facing ? (this.LASER ? (aActive ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_LASER[this.mTier + 1] : Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_LASER[this.mTier + 1]) : (aActive ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_64A[this.mTier + 1] : Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_64A[this.mTier + 1])) : GENNY;
        return iTextureArray;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("eEUT", this.EUT);
        aNBT.func_74768_a("eAMP", this.AMP);
        aNBT.func_74757_a("eLaser", this.LASER);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.EUT = aNBT.func_74762_e("eEUT");
        this.AMP = aNBT.func_74762_e("eAMP");
        this.LASER = aNBT.func_74767_n("eLaser");
        this.producing = (long)this.AMP * (long)this.EUT >= 0L;
        this.getBaseMetaTileEntity().setActive(this.producing);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(this.producing);
            if (!this.LASER) {
                if (aBaseMetaTileEntity.isActive()) {
                    this.setEUVar(this.maxEUStore());
                } else {
                    this.setEUVar(0L);
                }
            } else {
                byte Tick = (byte)(aTick % 20L);
                if (aBaseMetaTileEntity.isActive() && 16 == Tick) {
                    this.setEUVar(this.maxEUStore());
                    this.moveAround(aBaseMetaTileEntity);
                } else if (16 == Tick) {
                    this.setEUVar(0L);
                }
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return !this.LASER;
    }

    @Override
    public boolean isEnetInput() {
        return !this.LASER;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return !this.producing && side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return this.producing && side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public long maxAmperesIn() {
        return this.producing ? 0L : (long)Math.abs(this.AMP);
    }

    @Override
    public long maxAmperesOut() {
        return this.producing ? (long)Math.abs(this.AMP) : 0L;
    }

    @Override
    public long maxEUInput() {
        return this.producing ? 0L : Integer.MAX_VALUE;
    }

    @Override
    public long maxEUOutput() {
        return this.producing ? (long)Math.abs(this.EUT) : 0L;
    }

    @Override
    public long maxEUStore() {
        return this.LASER ? Math.abs((long)this.EUT * (long)this.AMP * 24L) : Math.abs((long)this.EUT * (long)this.AMP) << 2;
    }

    @Override
    public long getMinimumStoredEU() {
        return Math.abs((long)this.EUT * (long)this.AMP);
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    public int getEUT() {
        return this.EUT;
    }

    public void setEUT(int EUT) {
        this.EUT = EUT;
    }

    public int getAMP() {
        return this.AMP;
    }

    public void setAMP(int AMP) {
        this.AMP = AMP;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.LASER && side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    private void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        block0: for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            IMetaTileEntity aMetaTileEntity;
            IGregTechTileEntity tGTTileEntity;
            if (face == aBaseMetaTileEntity.getFrontFacing()) continue;
            ForgeDirection opposite = face.getOpposite();
            for (int dist = 1; dist < 1000 && (tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(face, dist)) != null && (aMetaTileEntity = tGTTileEntity.getMetaTileEntity()) != null; dist = (int)((short)(dist + 1))) {
                if (aMetaTileEntity instanceof MTEPipeLaserMirror) {
                    MTEPipeLaserMirror tMirror = (MTEPipeLaserMirror)aMetaTileEntity;
                    tGTTileEntity = tMirror.bendAround(opposite);
                    if (tGTTileEntity == null) continue block0;
                    aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
                    opposite = tMirror.getChainedFrontFacing();
                }
                if (aMetaTileEntity instanceof MTEHatchEnergyTunnel && opposite == tGTTileEntity.getFrontFacing()) {
                    if (this.maxEUOutput() > ((MTEHatchEnergyTunnel)aMetaTileEntity).maxEUInput()) {
                        aMetaTileEntity.doExplosion(this.maxEUOutput());
                        continue;
                    }
                    long diff = Math.min((long)this.AMP * 20L * this.maxEUOutput(), Math.min(((MTEHatchEnergyTunnel)aMetaTileEntity).maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), aBaseMetaTileEntity.getStoredEU()));
                    ((MTEHatchEnergyTunnel)aMetaTileEntity).setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                    continue;
                }
                if (!(aMetaTileEntity instanceof MTEPipeLaser) || ((MTEPipeLaser)aMetaTileEntity).connectionCount < 2) continue block0;
                ((MTEPipeLaser)aMetaTileEntity).markUsed();
            }
        }
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY).setSize(17, 17).setPos(113, 56));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setSize(90, 72).setPos(43, 4))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"tt.gui.text.debug.tier", (Object[])new Object[]{GTValues.VN[GTUtility.getTier(Math.abs(this.EUT))]})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 22))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"tt.gui.text.debug.sum", (Object[])new Object[]{numberFormat.format((long)this.AMP * (long)this.EUT)})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 46));
        this.addLabelledIntegerTextField(builder, StatCollector.func_74838_a((String)"tt.gui.text.debug.eut") + " ", 24, this::getEUT, this::setEUT, 46, 8);
        this.addLabelledIntegerTextField(builder, StatCollector.func_74838_a((String)"tt.gui.text.debug.amp") + " ", 24, this::getAMP, this::setAMP, 46, 34);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.EUT -= val.intValue(), 512, 64, 7, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.EUT /= val.intValue(), 512, 64, 7, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.AMP -= val.intValue(), 512, 64, 7, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.AMP /= val.intValue(), 512, 64, 7, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.EUT -= val.intValue(), 16, 1, 25, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.EUT /= val.intValue(), 16, 2, 25, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.AMP -= val.intValue(), 16, 1, 25, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.AMP /= val.intValue(), 16, 2, 25, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.EUT += val.intValue(), 16, 1, 133, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.EUT *= val.intValue(), 16, 2, 133, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.AMP += val.intValue(), 16, 1, 133, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.AMP *= val.intValue(), 16, 2, 133, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.EUT += val.intValue(), 512, 64, 151, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.EUT *= val.intValue(), 512, 64, 151, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.AMP += val.intValue(), 512, 64, 151, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.AMP *= val.intValue(), 512, 64, 151, 58);
    }

    private void addLabelledIntegerTextField(ModularWindow.Builder builder, String label, int labelWidth, IntSupplier getter, IntConsumer setter, int xPos, int yPos) {
        ((ModularWindow.Builder)builder.widget(new TextWidget(label).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(xPos, yPos))).widget(new NumericWidget().setGetter(getter::getAsInt).setSetter(val -> setter.accept((int)val)).setTextColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(xPos + labelWidth, yPos - 1).setSize(56, 10));
    }

    private void addChangeNumberButton(ModularWindow.Builder builder, IDrawable overlay, Consumer<Integer> setter, int changeNumberShift, int changeNumber, int xPos, int yPos) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            setter.accept(clickData.shift ? changeNumberShift : changeNumber);
            this.producing = (long)this.AMP * (long)this.EUT >= 0L;
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos));
    }

    static {
        numberFormat = new NumberFormatMUI();
    }
}

