/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.io.EPDOperation;
import com.jamesswafford.chess4j.io.FenParser;
import java.util.ArrayList;
import java.util.List;

public final class EPDParser {
    private EPDParser() {
    }

    public static List<EPDOperation> setPos(Board b, String epd) throws ParseException {
        String[] opsArr;
        ArrayList<EPDOperation> opsList = new ArrayList<EPDOperation>();
        int ind = 0;
        for (int i = 0; i < 4; ++i) {
            ind = epd.indexOf(32, ind + 1);
        }
        String fenPart = epd.substring(0, ind);
        FenParser.setPos(b, fenPart);
        String opsPart = epd.substring(ind + 1);
        for (String ops : opsArr = opsPart.split(";")) {
            List<Object> operands;
            String opCode;
            int opsInd = (ops = ops.trim()).indexOf(32);
            if (opsInd == -1) {
                opCode = ops;
                operands = new ArrayList();
            } else {
                opCode = ops.substring(0, opsInd);
                operands = EPDParser.getOperands(ops.substring(opsInd + 1));
            }
            EPDOperation epdOp = new EPDOperation(opCode);
            for (String string : operands) {
                epdOp.addOperand(string);
            }
            opsList.add(epdOp);
        }
        return opsList;
    }

    private static List<String> getOperands(String strOperands) {
        ArrayList<String> operands = new ArrayList<String>();
        if ("".equals(strOperands = strOperands.trim())) {
            return operands;
        }
        if (strOperands.charAt(0) == '\"') {
            int ind = strOperands.indexOf(34, 1);
            String myOperand = strOperands.substring(1, ind);
            operands.add(myOperand);
            operands.addAll(EPDParser.getOperands(strOperands.substring(ind + 1)));
        } else {
            int ind = strOperands.indexOf(32);
            if (ind == -1) {
                operands.add(strOperands);
            } else {
                String myOperand = strOperands.substring(0, ind);
                operands.add(myOperand);
                operands.addAll(EPDParser.getOperands(strOperands.substring(ind + 1)));
            }
        }
        return operands;
    }
}

